/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.help.ui;

import org.eclipse.dirigible.ide.ui.widget.extbrowser.ExtendedBrowser;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractHelpView
extends ViewPart {
    private final ISelectionListener selectionListener = new SelectionListenerImpl();
    private ExtendedBrowser browser = null;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.attachSelectionListener((IWorkbenchPartSite)site);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Composite holder = new Composite(parent, 0);
        holder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        holder.setLayout((Layout)new GridLayout(3, false));
        this.browser = new ExtendedBrowser(parent, 0);
        this.browser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.setUrl(this.getSiteUrl());
    }

    protected abstract String getSiteUrl();

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.detachSelectionListener(this.getSite());
        this.browser = null;
        super.dispose();
    }

    private void attachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.addSelectionListener(this.selectionListener);
        }
    }

    private void detachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.removeSelectionListener(this.selectionListener);
        }
    }

    private ISelectionService getSelectionService(IWorkbenchPartSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getSelectionService();
    }

    private void handleElementSelected(Object element) {
    }

    private class SelectionListenerImpl
    implements ISelectionListener {
        private SelectionListenerImpl() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                this.selectionChanged((IStructuredSelection)selection);
            }
        }

        private void selectionChanged(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element != null) {
                AbstractHelpView.this.handleElementSelected(element);
            }
        }
    }
}

