/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private static final String ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D = Messages.DeleteHandler_ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D;
    private static final String ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM = Messages.DeleteHandler_ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM;
    private static final String SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED = Messages.DeleteHandler_SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED;
    private static final String DELETE_ERROR = Messages.DeleteHandler_DELETE_ERROR;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute((IStructuredSelection)selection);
        }
        return null;
    }

    public void execute(IStructuredSelection selection) {
        ResourceComparator comparator = new ResourceComparator();
        TreeSet<IResource> resources = new TreeSet<IResource>(comparator);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                resources.add((IResource)element);
            }
            ++n2;
        }
        this.execute(resources);
    }

    private void closeFileInEditor(String fileName) {
        IEditorReference[] editors;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorRef.getEditor(false);
            if (editorPart != null && editorPart.getTitle().equals(fileName)) {
                page.closeEditor(editorPart, false);
                return;
            }
            ++n2;
        }
    }

    private void execute(SortedSet<IResource> resources) {
        if (resources.size() == 0) {
            return;
        }
        if (!DeleteHandler.confirmDelete(resources.size())) {
            return;
        }
        CoreException throwable = null;
        for (IResource resource : resources) {
            try {
                resource.delete(false, null);
                this.closeFileInEditor(resource.getName());
            }
            catch (CoreException ex) {
                if (throwable != null) continue;
                throwable = ex;
            }
        }
        if (throwable != null) {
            MessageDialog.openWarning(null, (String)DELETE_ERROR, (String)SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED);
        }
    }

    private static boolean confirmDelete(int count) {
        String message = "";
        message = count == 1 ? ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM : String.format(ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D, count);
        return MessageDialog.openConfirm(null, (String)Messages.DeleteHandler_CONFIRM_DELETE, (String)message);
    }

    private class ResourceComparator
    implements Comparator<IResource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IResource o1, IResource o2) {
            int segmentCount2;
            int segmentCount1 = o1.getFullPath().segmentCount();
            if (segmentCount1 == (segmentCount2 = o2.getFullPath().segmentCount())) {
                String path1 = o1.getFullPath().toString();
                String path2 = o2.getFullPath().toString();
                return path2.compareTo(path1);
            }
            return segmentCount2 - segmentCount1;
        }
    }
}

