/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBCollection;
import org.eclipse.dirigible.repository.db.DBResource;
import org.eclipse.dirigible.repository.db.DBResourceVersion;
import org.eclipse.dirigible.repository.db.Messages;
import org.eclipse.dirigible.repository.db.SimpleCacheManager;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.zip.ZipExporter;
import org.eclipse.dirigible.repository.zip.ZipImporter;

public class DBRepository
implements IRepository {
    private static final String PROVIDED_ZIP_DATA_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_DATA_CANNOT_BE_NULL");
    private static final String PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL");
    private static Logger logger = Logger.getLogger(DBRepository.class);
    public static final String PATH_DELIMITER = "/";
    private static final String WORKSPACE_PATH = "/";
    private DBRepositoryDAO repositoryDAO;
    private DataSource dataSource;
    private DBUtils dbUtils;
    private String user;
    private boolean cacheEnabled;
    private SimpleCacheManager cacheManager;

    public DBRepository(DataSource dataSource, String user, boolean forceRecreate) throws DBBaseException {
        this(dataSource, user, forceRecreate, true);
        logger.debug("exiting constructor");
    }

    public DBRepository(DataSource dataSource, String user, boolean forceRecreate, boolean cacheEnabled) throws DBBaseException {
        logger.debug("entering constructor");
        try {
            this.dataSource = dataSource;
            this.dbUtils = new DBUtils(dataSource);
            this.user = user;
            this.cacheEnabled = cacheEnabled;
            this.cacheManager = new SimpleCacheManager(!this.cacheEnabled);
            this.repositoryDAO = new DBRepositoryDAO(this);
            this.repositoryDAO.initialize(forceRecreate);
        }
        catch (SQLException e) {
            throw new DBBaseException(e);
        }
        logger.debug("exiting constructor");
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public SimpleCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ICollection getRoot() {
        logger.debug("entering getRoot");
        RepositoryPath wrapperPath = new RepositoryPath("/");
        DBCollection dbCollection = new DBCollection(this, wrapperPath);
        logger.debug("exiting getRoot");
        return dbCollection;
    }

    public ICollection createCollection(String path) throws IOException {
        logger.debug("entering createCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBCollection collection = new DBCollection(this, wrapperPath);
        collection.create();
        logger.debug("exiting createCollection");
        return collection;
    }

    public ICollection getCollection(String path) {
        logger.debug("entering getCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBCollection dbCollection = new DBCollection(this, wrapperPath);
        logger.debug("exiting getCollection");
        return dbCollection;
    }

    public void removeCollection(String path) throws IOException {
        logger.debug("entering removeCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBCollection collection = new DBCollection(this, wrapperPath);
        collection.delete();
        logger.debug("exiting removeCollection");
    }

    public boolean hasCollection(String path) throws IOException {
        logger.debug("entering hasCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBCollection collection = new DBCollection(this, wrapperPath);
        boolean result = collection.exists();
        logger.debug("exiting hasCollection");
        return result;
    }

    public IResource createResource(String path) throws IOException {
        logger.debug("entering createResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBResource resource = new DBResource(this, wrapperPath);
        resource.create();
        logger.debug("exiting createResource");
        return resource;
    }

    public IResource createResource(String path, byte[] content) throws IOException {
        logger.debug("entering createResource with Content");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBResource resource = new DBResource(this, wrapperPath);
        resource.setContent(content);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType) throws IOException {
        return this.createResource(path, content, isBinary, contentType, false);
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType, boolean override) throws IOException {
        logger.debug("entering createResource with Content");
        try {
            this.getRepositoryDAO().createFile(path, content, isBinary, contentType, override);
        }
        catch (DBBaseException e) {
            throw new IOException((Throwable)((Object)e));
        }
        IResource resource = this.getResource(path);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource getResource(String path) {
        logger.debug("entering getResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBResource dbResource = new DBResource(this, wrapperPath);
        logger.debug("exiting getResource");
        return dbResource;
    }

    public void removeResource(String path) throws IOException {
        logger.debug("entering removeResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBResource resource = new DBResource(this, wrapperPath);
        resource.delete();
        logger.debug("exiting removeResource");
    }

    public boolean hasResource(String path) throws IOException {
        logger.debug("entering hasResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        DBResource resource = new DBResource(this, wrapperPath);
        boolean result = resource.exists();
        logger.debug("exiting hasResource");
        return result;
    }

    public void dispose() {
        this.repositoryDAO.dispose();
    }

    public DBRepositoryDAO getRepositoryDAO() {
        return this.repositoryDAO;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DBUtils getDbUtils() {
        return this.dbUtils;
    }

    public String getUser() {
        return this.user;
    }

    public void importZip(ZipInputStream zipInputStream, String relativeRoot) throws IOException {
        this.importZip(zipInputStream, relativeRoot, false);
    }

    public void importZip(ZipInputStream zipInputStream, String relativeRoot, boolean override) throws IOException {
        this.importZip(zipInputStream, relativeRoot, false, false);
    }

    public void importZip(ZipInputStream zipInputStream, String relativeRoot, boolean override, boolean excludeRootFolderName) throws IOException {
        if (zipInputStream == null) {
            logger.error(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
        }
        ZipImporter.importZip((IRepository)this, (ZipInputStream)zipInputStream, (String)relativeRoot, (boolean)override, (boolean)excludeRootFolderName);
    }

    public void importZip(byte[] data, String relativeRoot) throws IOException {
        this.importZip(data, relativeRoot, false);
    }

    public void importZip(byte[] data, String relativeRoot, boolean override) throws IOException {
        this.importZip(data, relativeRoot, false, false);
    }

    public void importZip(byte[] data, String relativeRoot, boolean override, boolean excludeRootFolderName) throws IOException {
        if (data == null) {
            logger.error(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
        }
        ZipImporter.importZip((IRepository)this, (ZipInputStream)new ZipInputStream(new ByteArrayInputStream(data)), (String)relativeRoot, (boolean)override, (boolean)excludeRootFolderName);
    }

    public byte[] exportZip(List<String> relativeRoots) throws IOException {
        return ZipExporter.exportZip((IRepository)this, relativeRoots);
    }

    public byte[] exportZip(String relativeRoot, boolean inclusive) throws IOException {
        return ZipExporter.exportZip((IRepository)this, (String)relativeRoot, (boolean)inclusive);
    }

    public List<IEntity> searchName(String parameter, boolean caseInsensitive) throws IOException {
        return this.repositoryDAO.searchName(parameter, caseInsensitive);
    }

    public List<IEntity> searchName(String root, String parameter, boolean caseInsensitive) throws IOException {
        return this.repositoryDAO.searchName(root, parameter, caseInsensitive);
    }

    public List<IEntity> searchPath(String parameter, boolean caseInsensitive) throws IOException {
        return this.repositoryDAO.searchPath(parameter, caseInsensitive);
    }

    public List<IEntity> searchText(String parameter, boolean caseInsensitive) throws IOException {
        return this.repositoryDAO.searchText(parameter, caseInsensitive);
    }

    public List<IResourceVersion> getResourceVersions(String path) throws IOException {
        return this.repositoryDAO.getResourceVersionsByPath(path);
    }

    public IResourceVersion getResourceVersion(String path, int version) throws IOException {
        return new DBResourceVersion(this, new RepositoryPath(path), version);
    }

    public void cleanupOldVersions() throws IOException {
        this.repositoryDAO.cleanupOldVersions();
    }
}

