/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.datatools.sqltools.sqleditor.internal.sql.BestMatchHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SQLInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected IEditorPart _fEditor;
    protected IPartListener _fPartListener;
    protected String _fCurrentPerspective;
    protected BestMatchHover _fImplementation = new BestMatchHover(null);
    protected IInformationControlCreator _informationControlCreator;

    public SQLInformationProvider(IEditorPart editor) {
        this._fEditor = editor;
        if (this._fEditor != null) {
            this._fPartListener = new EditorWatcher();
            IWorkbenchWindow window = this._fEditor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this._fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this._fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this._fCurrentPerspective == null || this._fCurrentPerspective != perspectiveId) {
                this._fCurrentPerspective = perspectiveId;
                this._fImplementation.setEditor(this._fEditor);
            }
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (this._fImplementation != null) {
            IRegion r = this._fImplementation.getHoverRegion(textViewer, offset);
            return r;
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this._fImplementation != null && (s = this._fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        IInformationControlCreator controlCreator = null;
        if (this._fImplementation instanceof IInformationProviderExtension2) {
            controlCreator = this._fImplementation.getInformationPresenterControlCreator();
        }
        if (controlCreator != null) {
            return controlCreator;
        }
        if (this._informationControlCreator == null) {
            this._informationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    boolean cutDown = false;
                    int style = cutDown ? 0 : 768;
                    return new DefaultInformationControl(shell, 16, style, null);
                }
            };
        }
        return this._informationControlCreator;
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == SQLInformationProvider.this._fEditor) {
                SQLInformationProvider.this._fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(SQLInformationProvider.this._fPartListener);
                SQLInformationProvider.this._fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }
    }
}

