/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.debugger.breakpoint.ISPBreakpoint;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(SPDebugModelUtil.getModelIdentifier());
        for (int i = 0; i < breakpoints.length; ++i) {
            IBreakpoint breakpoint = breakpoints[i];
            if (!(breakpoint instanceof ISPBreakpoint)) continue;
            SPLineBreakpoint jBreakpoint = (SPLineBreakpoint)breakpoint;
            try {
                if (!this.breakpointAtRulerLine(jBreakpoint)) continue;
                return jBreakpoint;
            }
            catch (CoreException ce) {
                // empty catch block
            }
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected boolean breakpointAtRulerLine(SPLineBreakpoint jBreakpoint) throws CoreException {
        Position position;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null && (position = model.getMarkerPosition(jBreakpoint.getMarker())) != null) {
            IDocumentProvider provider = this.getTextEditor().getDocumentProvider();
            IDocument doc = provider.getDocument((Object)this.getTextEditor().getEditorInput());
            try {
                int markerLineNumber = doc.getLineOfOffset(position.getOffset());
                int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
                if (rulerLine == markerLineNumber) {
                    if (this.getTextEditor().isDirty()) {
                        return jBreakpoint.getLineNumber() == markerLineNumber + 1;
                    }
                    return true;
                }
            }
            catch (BadLocationException x) {
                // empty catch block
            }
        }
        return false;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.getTextEditor().getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }
}

