/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.ConstraintDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ASATableCheckConstraintDeltaDdlGenProvider
extends ConstraintDeltaDdlGenProvider {
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        super.getModificationResult(e, feature, oldValue, newValue, quoteIdentifiers, qualifyNames, fullSyntax, script);
        if (!(e instanceof CheckConstraint)) {
            return;
        }
        CheckConstraint rc = (CheckConstraint)e;
        if (feature.getFeatureID() == 7) {
            Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)rc);
            DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
            DDLGenerator ddlgen = def.getDDLGenerator();
            this.reCreateConstraint(ddlgen, rc, quoteIdentifiers, qualifyNames, fullSyntax, script);
        }
    }

    protected void reCreateConstraint(DDLGenerator ddlgen, CheckConstraint rc, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        int i;
        String newName = rc.getName();
        if (this.isNameChanged((SQLObject)rc)) {
            rc.setName(this.getOldName((SQLObject)rc));
        }
        String[] ddl = ddlgen.dropSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
        for (i = 0; i < ddl.length; ++i) {
            script.addAlterTableDropConstraintStatement(ddl[i]);
        }
        rc.setName(newName);
        ddl = ddlgen.createSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
        for (i = 0; i < ddl.length; ++i) {
            script.addAlterTableAddConstraintStatement(ddl[i]);
        }
    }

    protected boolean needGenerateRenamingDdl(Constraint constraint) {
        if (!(constraint instanceof CheckConstraint)) {
            return true;
        }
        CheckConstraint rc = (CheckConstraint)constraint;
        List list = (List)this._modifyRecordMap.get(rc);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() != 7) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isNameChanged(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() != 1) continue;
                return true;
            }
        }
        return false;
    }

    protected String getOldName(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() != 1) continue;
                return (String)cr.oldValue;
            }
        }
        return obj.getName();
    }

    protected String generateRenameConstraintStatement(Constraint constraint, String oldname, String newname, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer("");
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.eContainer(), quoteIdentifiers, qualifyNames)).append(" ").append("RENAME").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(oldname) : oldname).append(" ").append("TO").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(newname) : newname);
        return sb.toString();
    }
}

