/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogProvider;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogDatabase;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class SybaseASACatalogProvider
implements ICatalogProvider,
IExecutableExtension {
    private String product;
    private String version;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
    }

    public Database getCatalogDatabase(Connection connection) {
        SybaseASACatalogDatabase database = new SybaseASACatalogDatabase(connection);
        this.retrieveRealVersion(connection);
        database.setVendor(this.product);
        database.setVersion(this.version);
        return database;
    }

    private void retrieveRealVersion(Connection connection) {
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT @@version");
            while (rs.next()) {
                this.version = rs.getString(1);
                if (this.version.startsWith("9")) {
                    this.version = "9.x";
                    continue;
                }
                if (!this.version.startsWith("10")) continue;
                this.version = "10.x";
            }
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }
}

