/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TypeOfDefault;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpressionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class SybaseASABaseColumnLoader {
    protected Connection conn;
    protected SybaseASABaseColumn column;
    protected ICatalogObject catalogObj;

    public SybaseASABaseColumnLoader(SybaseASABaseColumn catalogColumn) {
        this.conn = ((ICatalogObject)catalogColumn).getConnection();
        this.column = catalogColumn;
        this.catalogObj = (ICatalogObject)catalogColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumnInfo() {
        boolean deliver = this.column.eDeliver();
        this.column.eSetDeliver(false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Table table = this.column.getTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = this.conn.prepareStatement("SELECT DISTINCT C.column_id, TRIM(C.column_name) as column_name, TRIM(D.domain_name) as domain_name, C.width, C.scale, TRIM(Y.type_name), TRIM(UT.user_name), C.\"nulls\", IFNULL( I.index_id, 'N', 'Y' ) AS \"unique\",C.column_type, C.\"default\", C.remarks FROM SYS.SYSCOLUMN C JOIN SYS.SYSDOMAIN D ON D.domain_id = C.domain_id LEFT OUTER JOIN SYS.SYSUSERTYPE Y ON Y.type_id = C.user_type LEFT OUTER JOIN SYS.SYSINDEX I ON I.table_id = C.table_id AND I.\"unique\" = 'U' AND (SELECT COUNT(*) FROM SYS.SYSIXCOL XA WHERE XA.table_id = I.table_id AND XA.index_id = I.index_id AND XA.column_id = C.column_id) = 1 AND (SELECT COUNT(*) FROM SYS.SYSIXCOL XB WHERE XB.table_id = I.table_id AND XB.index_id = I.index_id AND XB.column_id <> C.column_id) = 0 JOIN SYS.SYSTABLE T ON T.table_id = C.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator LEFT JOIN SYS.SYSUSERPERMS UT ON UT.user_id = Y.creator WHERE U.user_name like ? AND T.table_name like ? AND C.column_name like ?");
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.column.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processResultSet(rs);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.column.eSetDeliver(deliver);
    }

    protected void processResultSet(ResultSet rs) throws SQLException {
        DatabaseDefinition dbDefn = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.catalogObj.getCatalogDatabase());
        String domainName = rs.getString(3);
        System.out.println();
        int width = rs.getInt(4);
        int scale = rs.getInt(5);
        String typeName = rs.getString(6);
        String typeOwner = rs.getString(7);
        boolean isNullable = rs.getString(8).equals("Y");
        boolean isUnique = rs.getString(9).equals("Y");
        char colType = SybaseASACatalogUtils.getCharValue(rs.getString(10));
        String defaultValue = rs.getString(11);
        String remarks = rs.getString(12);
        PredefinedDataType type = null;
        if (typeName == null || typeName.equals("")) {
            type = SybaseASACatalogUtils.getASAPredefinedType(width, scale, domainName, dbDefn);
        } else {
            Schema typeSchema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), typeOwner);
            type = (DataType)SybaseASACatalogUtils.findElement((Collection)typeSchema.getUserDefinedTypes(), typeName);
        }
        this.column.setDataType((DataType)type);
        this.column.setNullable(isNullable);
        this.column.setDescription(remarks);
        this.column.setUnique(isUnique);
        if (colType == 'C') {
            ValueExpressionDefault vExpr = SQLExpressionsFactory.eINSTANCE.createValueExpressionDefault();
            vExpr.setSQL(defaultValue);
            this.column.setGenerateExpression((ValueExpression)vExpr);
            this.column.setTypeOfDefault(TypeOfDefault.COMPUTED_VALUE_LITERAL);
        } else {
            this.column.setDefaultValue(defaultValue);
            if (defaultValue != null) {
                this.column.setTypeOfDefault(SybaseASACatalogUtils.isSystemDefault(defaultValue) ? TypeOfDefault.SYSTEM_DEFINED_LITERAL : TypeOfDefault.USER_DEFINED_LITERAL);
            } else {
                this.column.setTypeOfDefault(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumnCheckConstraint(SybaseASABaseColumnCheckConstraint oldColCheck) {
        boolean deliver = this.column.eDeliver();
        this.column.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        SybaseASACatalogBaseColumnCheckConstraint check = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Table table = this.column.getTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = this.conn.prepareStatement(SQLScriptsProvider.getQueryColumnConstraintsScript((Database)db));
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.column.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String checkName = rs.getString(1);
                if (oldColCheck != null && oldColCheck.getName().equals(checkName)) {
                    check = oldColCheck;
                    ((ICatalogObject)check).refresh();
                    continue;
                }
                check = new SybaseASACatalogBaseColumnCheckConstraint();
                check.setName(checkName);
            }
            this.column.setColumnConstraint(check);
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.column.eSetDeliver(deliver);
    }
}

