/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLFileManager {
    private static final String FILENAME = "PropertySets.xml";
    private static final String ROOTNAME = "DataTools.PropertySets";
    private static final String CHILDNAME = "propertySet";
    private static final String PROPSETNAME = "name";
    private static final String PROPSETID = "iD";
    private static final String PROPSETKEYS = "keys";
    private static final String PROPPREFIX = "prop_";
    private static final String PROPDELIM = " ";
    private static IPath storageLocation = null;
    private static String mFileName = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transFactory = null;
    private static Transformer transformer = null;

    public XMLFileManager() {
        mFileName = FILENAME;
    }

    private static String keysToString(Enumeration enu) {
        StringBuffer keys = new StringBuffer();
        while (enu.hasMoreElements()) {
            keys.append(String.valueOf((String)enu.nextElement()) + PROPDELIM);
        }
        return keys.toString();
    }

    private static Properties keysToProperties(Element elem) {
        Properties props = new Properties();
        String keys = elem.getAttribute(PROPSETKEYS);
        StringTokenizer st = new StringTokenizer(keys, PROPDELIM);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = elem.getAttribute(PROPPREFIX + key);
            props.put(key, value);
        }
        return props;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void saveNamedPropertySet(IPropertySet[] pss) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(ROOTNAME);
            document.appendChild(rootElement);
            Element child = null;
            IPath path = XMLFileManager.getStorageLocation();
            path = path.append(mFileName);
            File file = path.toFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream outs = new FileOutputStream(file);
            Writer writer = null;
            try {
                OutputStreamWriter outw = new OutputStreamWriter((OutputStream)outs, "UTF-8");
                writer = new BufferedWriter(outw);
                int i = 0;
                while (true) {
                    block14: {
                        if (i < pss.length) break block14;
                        DOMSource source = new DOMSource(document);
                        StreamResult result = new StreamResult(outw);
                        XMLFileManager.getTransformer().transform(source, result);
                        break;
                    }
                    IPropertySet ps = pss[i];
                    if (ps != null) {
                        child = document.createElement(CHILDNAME);
                        child.setAttribute(PROPSETNAME, ps.getName());
                        child.setAttribute(PROPSETID, ps.getID());
                        Properties props = ps.getBaseProperties();
                        String keys = XMLFileManager.keysToString(props.keys());
                        child.setAttribute(PROPSETKEYS, keys);
                        Enumeration<?> enu = props.propertyNames();
                        while (true) {
                            if (!enu.hasMoreElements()) {
                                rootElement.appendChild(child);
                                break;
                            }
                            String key = (String)enu.nextElement();
                            String value = props.getProperty(key);
                            child.setAttribute(PROPPREFIX + key, value);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                if (writer != null) {
                    writer.close();
                }
                if (outs == null) throw throwable;
                ((OutputStream)outs).close();
                throw throwable;
            }
            {
                Object var18_24 = null;
                if (writer != null) {
                    writer.close();
                }
                if (outs == null) return;
                ((OutputStream)outs).close();
                return;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized IPropertySet[] loadPropertySets() throws CoreException {
        IPropertySet[] iPropertySetArray;
        InputStream fis;
        block16: {
            IPropertySet[] iPropertySetArray2;
            block15: {
                fis = null;
                try {
                    try {
                        IPath path = XMLFileManager.getStorageLocation();
                        path = path.append(mFileName);
                        File file = path.toFile();
                        if (!file.exists()) {
                            iPropertySetArray2 = new IPropertySet[]{};
                            Object var14_7 = null;
                            if (fis == null) return iPropertySetArray2;
                            break block15;
                        }
                        fis = new FileInputStream(file);
                        InputSource source = new InputSource(fis);
                        source.setEncoding("UTF-8");
                        Document document = XMLFileManager.getDocumentBuilder().parse(source);
                        ArrayList<PropertySetImpl> pss = new ArrayList<PropertySetImpl>();
                        NodeList nl = document.getElementsByTagName(CHILDNAME);
                        int i = 0;
                        while (true) {
                            if (i >= nl.getLength()) {
                                if (fis == null) break;
                                try {
                                    fis.close();
                                    break;
                                }
                                catch (IOException e) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                                }
                            }
                            Node node = nl.item(i);
                            if (node instanceof Element) {
                                Element elem = (Element)node;
                                String name = elem.getAttribute(PROPSETNAME);
                                String id = elem.getAttribute(PROPSETID);
                                Properties props = XMLFileManager.keysToProperties(elem);
                                PropertySetImpl ps = new PropertySetImpl(name, id);
                                ps.setBaseProperties(props);
                                pss.add(ps);
                            }
                            ++i;
                        }
                        iPropertySetArray = pss.toArray(new IPropertySet[0]);
                        break block16;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                    }
                    catch (SAXException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var14_9 = null;
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                    }
                }
            }
            try {}
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
            }
            fis.close();
            return iPropertySetArray2;
        }
        Object var14_8 = null;
        if (fis == null) return iPropertySetArray;
        try {}
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
        }
        fis.close();
        return iPropertySetArray;
    }

    public static IPath getStorageLocation() {
        if (storageLocation == null) {
            return ConnectivityPlugin.getDefault().getStateLocation();
        }
        return storageLocation;
    }

    public static void setStorageLocation(IPath location) {
        storageLocation = location;
    }

    public static String getFileName() {
        return mFileName;
    }

    public static void setFileName(String name) {
        mFileName = name;
    }

    public static String getFileDateTimeStamp() {
        IPath path = XMLFileManager.getStorageLocation();
        File file = (path = path.append(mFileName)).toFile();
        if (!file.exists()) {
            return null;
        }
        Long modified = new Long(file.lastModified());
        return modified.toString();
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return documentBuilder;
    }

    private static Transformer getTransformer() {
        if (transformer == null) {
            transFactory = TransformerFactory.newInstance();
            try {
                transformer = transFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return transformer;
    }
}

