/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.io.File;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ExportProfilesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportProfileViewAction
extends Action
implements IViewActionDelegate {
    private Shell shell;

    public ExportProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.exportCPs"));
    }

    public void init(IViewPart view) {
        this.shell = view.getSite().getShell();
    }

    public void run() {
        final ExportProfilesDialog dlg = new ExportProfilesDialog(this.shell);
        int ret = dlg.open();
        if (ret == 0) {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        ICipherProvider isp = null;
                        if (dlg.needEncryption()) {
                            isp = SecurityManager.getInstance().getDefaultCipherProvider();
                        }
                        ConnectionProfileMgmt.saveCPs((IConnectionProfile[])dlg.getSelectedProfiles(), (File)dlg.getFile(), (ICipherProvider)isp);
                    }
                    catch (Exception e) {
                        ExceptionHandler.showException(ExportProfileViewAction.this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                    }
                }
            });
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

