/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCopyProcessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class DuplicateProfileAction
extends Action
implements IActionDelegate {
    private Shell mParentShell = null;
    private IConnectionProfile mConnectionProfile = null;

    public DuplicateProfileAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run() {
        try {
            this.refactor(this.mConnectionProfile);
        }
        catch (CoreException e) {
            ExceptionHandler.showException(this.mParentShell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
        }
    }

    private void refactor(IConnectionProfile profile) throws CoreException {
        Object o = null;
        o = profile.getParentProfile() == null ? ProfileManager.getInstance() : profile.getParentProfile();
        PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new CopyRefactoring((CopyProcessor)new ConnectionProfileCopyProcessor(new IConnectionProfile[]{profile}, o)), 6);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException oce) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mConnectionProfile = null;
        if (selection instanceof IStructuredSelection) {
            Object selectedResource;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(false);
            if (structuredSelection.size() == 1 && (selectedResource = structuredSelection.getFirstElement()) instanceof ConnectionProfile) {
                IConnectionProfileRepository repo = ((ConnectionProfile)selectedResource).getRepository();
                action.setEnabled(repo == null || !repo.isReadOnly());
                this.mConnectionProfile = (IConnectionProfile)selectedResource;
            }
        }
    }
}

