/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileMoveChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ConnectionProfileMoveProcessor
extends MoveProcessor {
    public static final String PROCESSOR_ID = "org.eclipse.datatools.connectivity.ui.moveProcessor";
    private IConnectionProfile[] mProfiles;
    private List mProfilesToMove;
    private MoveArguments mArguments;

    public ConnectionProfileMoveProcessor(IConnectionProfile[] profiles, Object destination) {
        this.mProfiles = profiles;
        this.mProfilesToMove = new ArrayList();
        this.mArguments = new MoveArguments(destination, true);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        IConnectionProfileRepository repo = this.getTargetRepository();
        int count = this.mProfiles.length;
        for (int index = 0; index < count; ++index) {
            if (repo != null ? repo.isReadOnly() || repo.getProfileByName(this.mProfiles[index].getName()) != null || !repo.supportsProfileType(this.mProfiles[index].getProviderId()) || !((ConnectionProfileProvider)this.mProfiles[index].getProvider()).compatibleWithRepository(repo.getRepositoryProfile()) : InternalProfileManager.getInstance().getProfileByName(this.mProfiles[index].getName(), false) != null) continue;
            this.mProfilesToMove.add(this.mProfiles[index]);
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(new String());
        change.markAsSynthetic();
        Iterator it = this.mProfilesToMove.iterator();
        while (it.hasNext()) {
            change.add((Change)new ConnectionProfileMoveChange((IConnectionProfile)it.next(), this.mArguments));
        }
        return change;
    }

    public Object[] getElements() {
        return this.mProfiles;
    }

    public String getIdentifier() {
        return PROCESSOR_ID;
    }

    public String getProcessorName() {
        return ConnectivityUIPlugin.getDefault().getResourceString("CPMoveProcessor.name");
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<MoveParticipant> participants = new ArrayList<MoveParticipant>();
        int count = this.mProfiles.length;
        for (int index = 0; index < count; ++index) {
            participants.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.mProfiles[index], (MoveArguments)this.mArguments, (String[])new String[0], (SharableParticipants)sharedParticipants)));
        }
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    private IConnectionProfileRepository getTargetRepository() throws CoreException {
        Object destination = this.mArguments.getDestination();
        if (destination instanceof ProfileManager) {
            return null;
        }
        if (destination instanceof IConnectionProfile) {
            IManagedConnection imc = ((IConnectionProfile)destination).getManagedConnection(IConnectionProfileRepository.class.getName());
            if (imc == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
                throw new CoreException((IStatus)status);
            }
            if (!imc.isConnected() || imc.getConnection() == null || imc.getConnection().getRawConnection() == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.RepositoryNotConnected", new Object[]{((IConnectionProfile)destination).getName()}), null);
                throw new CoreException((IStatus)status);
            }
            return (IConnectionProfileRepository)imc.getConnection().getRawConnection();
        }
        Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
        throw new CoreException((IStatus)status);
    }
}

