/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.input;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.util.FileUtil;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.ui.part.FileEditorInput;

public class SQLBuilderFileEditorInput
extends FileEditorInput
implements ISQLBuilderEditorInput {
    private String fSQLStatement;
    private ISQLEditorConnectionInfo fConnInfo;
    private IOmitSchemaInfo fOmitSchemaInfo;
    private IWindowStateInfo fWindowStateInfo;
    private ISQLBuilderEditorInputUsageOptions fInputUsageOptions;

    public SQLBuilderFileEditorInput(IFile aFile) {
        super(aFile);
        ISQLEditorConnectionInfo connectionInfo = SQLFileUtil.getConnectionInfo(aFile);
        this.setConnectionInfo(connectionInfo);
        IOmitSchemaInfo omitSchemaInfo = SQLFileUtil.getOmitSchemaInfo(aFile);
        this.setOmitSchemaInfo(omitSchemaInfo);
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo == null ? SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO : connInfo;
    }

    public void setOmitSchemaInfo(IOmitSchemaInfo omitSchemaInfo) {
        if (omitSchemaInfo == null) {
            this.fOmitSchemaInfo = new OmitSchemaInfo();
            this.fOmitSchemaInfo.initFromPreferences();
        } else {
            this.fOmitSchemaInfo = omitSchemaInfo;
        }
    }

    public IOmitSchemaInfo getOmitSchemaInfo() {
        return this.fOmitSchemaInfo;
    }

    public String getSQL() {
        if (this.fSQLStatement == null) {
            try {
                this.fSQLStatement = FileUtil.getFileContents(this.getFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.fSQLStatement;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public String getId() {
        return this.toString();
    }

    public IWindowStateInfo getWindowStateInfo() {
        return this.fWindowStateInfo;
    }

    public void setWindowStateInfo(IWindowStateInfo windowStateInfo) {
        this.fWindowStateInfo = windowStateInfo;
    }

    public ISQLBuilderEditorInputUsageOptions getInputUsageOptions() {
        return this.fInputUsageOptions;
    }

    public void setInputUsageOptions(ISQLBuilderEditorInputUsageOptions options) {
        this.fInputUsageOptions = options;
    }
}

