/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.common.ui.sqlstatementarea.ISQLSourceViewerService;
import org.eclipse.datatools.sqltools.common.ui.sqlstatementarea.SQLStatementArea;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLProvider;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.SQLSourceViewerService;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.CommonAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.SQLSourceViewerConfiguration;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.SaveAsAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.utils.Images;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class DDLPage
extends SchemaObjectEditorPage
implements ISchemaObjectEditorPage {
    private SQLStatementArea _sta;
    private Map _actions = new HashMap();
    private IDDLProvider _provider;
    private Color _bgColor;

    public DDLPage() {
    }

    public DDLPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public DDLPage(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.initDDLProvider();
        Composite comp = managedForm.getForm().getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        this.createSQLArea(comp);
    }

    private void initDDLProvider() {
        ISchemaObjectEditor editor = (ISchemaObjectEditor)this.getEditor();
        ISchemaObjectEditor part = editor;
        ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)part.getEditorInput();
        if (input.getEditModelObject().getAdapter(IDDLProvider.class) != null) {
            this._provider = (IDDLProvider)input.getEditModelObject().getAdapter(IDDLProvider.class);
        }
    }

    private void initializeActions() {
        CommonAction action = new CommonAction(this._sta.getViewer().getTextOperationTarget(), 4, Messages.DDLPage_copy);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this._actions.put(ITextEditorActionConstants.COPY, action);
        action = new CommonAction(this._sta.getViewer().getTextOperationTarget(), 7, Messages.DDLPage_selectall);
        this._actions.put(ITextEditorActionConstants.SELECT_ALL, action);
    }

    private void createSQLArea(Composite comp) {
        ISchemaObjectEditor editor = (ISchemaObjectEditor)this.getEditor();
        String dbType = String.valueOf(editor.getEditorDescriptor().getVendorName()) + "_" + editor.getEditorDescriptor().getVersion();
        this._sta = new SQLStatementArea(comp, 0, (ISQLSourceViewerService)new SQLSourceViewerService(), true);
        String ddlContent = "";
        if (this._provider != null) {
            ddlContent = this._provider.getDDL();
        }
        this._sta.setInput(ddlContent, dbType);
        this._sta.setEditable(false);
        this._sta.setEnabled(true);
        this._sta.configureViewer((SourceViewerConfiguration)new SQLSourceViewerConfiguration(dbType));
        this._sta.setLayoutData((Object)new GridData(1808));
        this._bgColor = Util.getBackGroundColor((Device)this._sta.getViewer().getControl().getDisplay());
        if (this._bgColor != null) {
            this._sta.getViewer().getTextWidget().setBackground(this._bgColor);
        }
        this.initializeActions();
        this.createContextMenu();
    }

    private void createContextMenu() {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object obj : DDLPage.this._actions.values()) {
                    if (!(obj instanceof IUpdate)) continue;
                    IUpdate action = (IUpdate)obj;
                    action.update();
                }
                menuMgr.add((IAction)DDLPage.this._actions.get(ITextEditorActionConstants.COPY));
                menuMgr.add((IAction)DDLPage.this._actions.get(ITextEditorActionConstants.SELECT_ALL));
                menuMgr.add((IContributionItem)new Separator());
                String ddlContent = "";
                if (DDLPage.this._provider != null) {
                    ddlContent = DDLPage.this._provider.getDDL();
                }
                SaveAsAction saveAs = new SaveAsAction(ddlContent, (ISchemaObjectEditor)DDLPage.this.getEditor(), DDLPage.this.getDatabaseIdentifier());
                saveAs.setText(Messages.DDLPage_saveas);
                saveAs.setImageDescriptor(Images.DESC_SAVEAS_ACTION);
                saveAs.setEnabled(ddlContent != null && !ddlContent.trim().equals(""));
                menuMgr.add((IAction)saveAs);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._sta.getViewer().getTextWidget());
        this._sta.getViewer().getTextWidget().setMenu(menu);
        this._sta.getViewer().getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                CommonAction action;
                if (event.keyCode == 97 && (event.stateMask & 0x40000) != 0 && (action = (CommonAction)((Object)DDLPage.this._actions.get(ITextEditorActionConstants.SELECT_ALL))) != null) {
                    action.run();
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        if (!this.isPageOpened()) {
            return;
        }
        this.initDDLProvider();
        this.updateDDL();
    }

    private void updateDDL() {
        String ddlContent = "";
        if (this._provider != null) {
            ddlContent = this._provider.getDDL();
        }
        ISchemaObjectEditor editor = (ISchemaObjectEditor)this.getEditor();
        String dbType = String.valueOf(editor.getEditorDescriptor().getVendorName()) + "_" + editor.getEditorDescriptor().getVersion();
        if (this._sta != null) {
            this._sta.setInput(ddlContent, dbType);
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateDDL();
        }
    }

    public void dispose() {
        super.dispose();
        if (this._bgColor != null && !this._bgColor.isDisposed()) {
            this._bgColor.dispose();
        }
    }
}

