/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;

public class ExpressionElement {
    private QueryValueExpression expression;
    private ValueExpressionCombinedOperator operator = null;
    private WeakReference exprElementVectorRef;
    int paramNum = 0;

    public ExpressionElement(QueryValueExpression expr, ValueExpressionCombinedOperator opr) {
        this.expression = expr;
        this.operator = opr;
    }

    public ExpressionElement(QueryValueExpression expr, ValueExpressionCombinedOperator opr, int paramNo) {
        this.expression = expr;
        this.operator = opr;
        this.paramNum = paramNo;
    }

    public QueryValueExpression getExpression() {
        return this.expression;
    }

    public int getParameterNum() {
        return this.paramNum;
    }

    public String getColumnLabel() {
        String label = "...";
        Vector elements = this.getElementsVector();
        ExpressionElement firstElement = (ExpressionElement)elements.get(0);
        if (this.equals(firstElement)) {
            int paramNo = firstElement.getParameterNum();
            label = "#" + String.valueOf(paramNo + 1);
        }
        return label;
    }

    public Vector getElementsVector() {
        Vector elements = null;
        if (this.exprElementVectorRef != null) {
            elements = (Vector)this.exprElementVectorRef.get();
        }
        return elements;
    }

    public void setOperator(String newOpString) {
        ValueExpressionCombinedOperator newOperator = ExpressionHelper.createCombinedOperator(newOpString);
        if (newOperator != null) {
            if (this.operator == null) {
                ExpressionHelper.addExpression(this.expression, null, newOperator);
            } else {
                ExpressionHelper.replaceOperator(this.expression, newOperator);
            }
        }
    }

    public ValueExpressionCombinedOperator getOperator() {
        return this.operator;
    }

    public String getOperatorString() {
        String opStr = "";
        if (this.operator != null) {
            opStr = ExpressionHelper.getDisplayString(this.operator.toString());
        }
        return opStr;
    }

    ValueExpressionCombinedOperator getOperatorFromPreviousRow() {
        Vector elements;
        int currentPos;
        ValueExpressionCombinedOperator opr = null;
        if (this.exprElementVectorRef != null && (currentPos = (elements = (Vector)this.exprElementVectorRef.get()).indexOf(this)) - 1 >= 0) {
            ExpressionElement element = (ExpressionElement)elements.get(currentPos - 1);
            opr = element.getOperator();
        }
        return opr;
    }

    QueryValueExpression getPreviousRowExpr() {
        Vector elements;
        int currentPos;
        QueryValueExpression expr = null;
        if (this.exprElementVectorRef != null && (currentPos = (elements = (Vector)this.exprElementVectorRef.get()).indexOf(this)) - 1 >= 0) {
            ExpressionElement element = (ExpressionElement)elements.get(currentPos - 1);
            expr = element.getExpression();
        }
        return expr;
    }

    public void setExpression(QueryValueExpression expr) {
        Object newExpr = null;
        newExpr = expr instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)expr) : expr;
        if (this.expression == null) {
            QueryValueExpression prevExpr = this.getPreviousRowExpr();
            ValueExpressionCombinedOperator opr = this.getOperatorFromPreviousRow();
            ExpressionHelper.addExpression(prevExpr, newExpr, opr);
        } else {
            ExpressionHelper.replaceExpression(this.expression, newExpr);
        }
        this.expression = newExpr;
    }

    public void deleteExpression() {
        ExpressionHelper.removeExpression(this.expression);
        this.expression = null;
        this.removeElement();
    }

    public void removeElement() {
        Vector elements;
        if (this.exprElementVectorRef != null && (elements = (Vector)this.exprElementVectorRef.get()) != null) {
            elements.remove(this);
        }
    }

    public String getExpressionString() {
        String str = "";
        if (this.expression != null) {
            str = this.expression.getSQL();
        }
        return str;
    }

    public void setExprElementVectorRef(WeakReference newRef) {
        this.exprElementVectorRef = newRef;
    }
}

