/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.launcher.TestListenerRegistry;
import org.eclipse.unittest.internal.launcher.TestRunListener;
import org.eclipse.unittest.internal.launcher.TestViewSupportRegistry;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.UnitTestModel;
import org.eclipse.unittest.ui.ITestViewSupport;

public class UnitTestLaunchListener
implements ILaunchListener {
    private HashSet<ILaunch> fTrackedLaunches = new HashSet(20);

    public void launchAdded(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return;
        }
        try {
            if (!config.hasAttribute("org.eclipse.unittest.ui.TEST_VIEW_SUPPPORT")) {
                return;
            }
        }
        catch (CoreException e1) {
            UnitTestPlugin.log(e1);
            return;
        }
        ITestViewSupport testRunnerViewSupport = TestViewSupportRegistry.newTestRunnerViewSupport(config).orElse(null);
        if (testRunnerViewSupport == null) {
            return;
        }
        this.fTrackedLaunches.add(launch);
    }

    public void launchRemoved(ILaunch launch) {
        this.fTrackedLaunches.remove(launch);
    }

    public void launchChanged(ILaunch launch) {
        if (!this.fTrackedLaunches.contains(launch)) {
            return;
        }
        if (UnitTestModel.getInstance().getTestRunSessions().stream().noneMatch(session -> launch.equals(session.getLaunch()))) {
            TestRunSession testRunSession = new TestRunSession(launch);
            UnitTestModel.getInstance().addTestRunSession(testRunSession);
            for (TestRunListener listener : TestListenerRegistry.getDefault().getUnitTestRunListeners()) {
                listener.sessionLaunched(testRunSession);
            }
        }
    }
}

