/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.text.MessageFormat;
import java.time.Duration;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.ui.BasicElementLabels;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.internal.ui.TestRunnerViewPart;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;

class TestSessionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final TestRunnerViewPart.TestResultsLayout fLayoutMode;
    private boolean fShowTime;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, TestRunnerViewPart.TestResultsLayout layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
        this.fShowTime = true;
    }

    public StyledString getStyledText(Object element) {
        if (!(element instanceof ITestElement)) {
            return new StyledString(element.toString());
        }
        TestElement testElement = (TestElement)element;
        StyledString text = new StyledString(testElement.getDisplayName());
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            String displayName;
            if (testElement.getParentContainer() instanceof ITestRunSession && (displayName = this.fTestRunnerPart.getDisplayName()) != null) {
                String decorated = MessageFormat.format(Messages.TestSessionLabelProvider_testName_RunnerVersion, text.getString(), displayName);
                text = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)text);
            }
        } else if (element instanceof TestCaseElement) {
            String decorated = this.getTextForFlatLayout((TestCaseElement)testElement, text.getString());
            text = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)text);
        }
        return this.addElapsedTime(text, testElement.getDuration());
    }

    private String getTextForFlatLayout(TestCaseElement testCaseElement, String label) {
        String parentDisplayName = testCaseElement.getParent().getDisplayName();
        String parentName = parentDisplayName != null ? parentDisplayName : testCaseElement.getTestName();
        return MessageFormat.format(Messages.TestSessionLabelProvider_testMethodName_className, label, BasicElementLabels.getJavaElementName(parentName));
    }

    private StyledString addElapsedTime(StyledString styledString, Duration duration) {
        String string = styledString.getString();
        String decorated = this.addElapsedTime(string, duration);
        return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)styledString);
    }

    private String addElapsedTime(String string, Duration duration) {
        if (!this.fShowTime || duration == null) {
            return string;
        }
        return MessageFormat.format(Messages.TestSessionLabelProvider_testName_elapsedTimeInSeconds, string, (double)duration.toNanos() / 1.0E9);
    }

    public String getText(Object element) {
        if (!(element instanceof ITestElement)) {
            return element.toString();
        }
        TestElement testElement = (TestElement)element;
        String label = testElement.getDisplayName();
        if (this.fLayoutMode == TestRunnerViewPart.TestResultsLayout.HIERARCHICAL) {
            String displayName;
            if ((testElement instanceof ITestRunSession || testElement.getParent() instanceof ITestRunSession && testElement.getParent().getChildren().size() <= 1) && (displayName = this.fTestRunnerPart.getDisplayName()) != null) {
                label = MessageFormat.format(Messages.TestSessionLabelProvider_testName_RunnerVersion, label, displayName);
            }
        } else if (element instanceof TestCaseElement) {
            label = this.getTextForFlatLayout((TestCaseElement)testElement, label);
        }
        return this.addElapsedTime(label, testElement.getDuration());
    }

    public Image getImage(Object element) {
        if (element instanceof TestElement && ((TestElement)element).isAssumptionFailure()) {
            return this.fTestRunnerPart.fTestAssumptionFailureIcon;
        }
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestElement) {
            Status status = ((TestElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    public void setShowTime(boolean showTime) {
        this.fShowTime = showTime;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

