/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EAnnotationItemProvider;
import org.eclipse.emf.ecore.provider.EStringToStringMapEntryItemProvider;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EAnnotationItemProviderAdapterFactory
extends AdapterFactoryImpl
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected final IChangeNotifier changeNotifier = new ChangeNotifier();
    protected final Collection<Object> supportedTypes = new ArrayList<Object>();
    protected final Disposable disposable = new Disposable();
    protected final EcoreSwitch<Adapter> modelSwitch = new EcoreSwitch<Adapter>(){

        public Adapter caseEAnnotation(EAnnotation object) {
            return EAnnotationItemProviderAdapterFactory.this.createEAnnotationAdapter();
        }

        public Adapter caseEStringToStringMapEntry(Map.Entry<String, String> object) {
            return EAnnotationItemProviderAdapterFactory.this.createEStringToStringMapEntryAdapter();
        }
    };
    protected final BasicEAnnotationValidator.Assistant assistant;
    protected final ResourceLocator resourceLocator;
    protected EcoreItemProviderAdapterFactory ecoreItemProviderAdapterFactory;
    protected Adapter eAnnotationItemProvider;
    protected Adapter eStringToStringMapEntryItemProvider;

    public EAnnotationItemProviderAdapterFactory(ResourceLocator resourceLocator, BasicEAnnotationValidator.Assistant assistant) {
        this.resourceLocator = resourceLocator;
        this.assistant = assistant;
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public BasicEAnnotationValidator.Assistant getAssistant() {
        return this.assistant;
    }

    public boolean isShowInstances(EAnnotation eAnnotation) {
        return this.assistant.getPropertyClasses(eAnnotation.getEModelElement()).size() > 1;
    }

    public Adapter createEAnnotationAdapter() {
        if (this.eAnnotationItemProvider == null) {
            this.eAnnotationItemProvider = this.doCreateEAnnotationAdapter();
        }
        return this.eAnnotationItemProvider;
    }

    protected Adapter doCreateEAnnotationAdapter() {
        return new EAnnotationItemProvider((AdapterFactory)this);
    }

    public Adapter createEStringToStringMapEntryAdapter() {
        if (this.eStringToStringMapEntryItemProvider == null) {
            this.eStringToStringMapEntryItemProvider = this.doCreateEStringToStringMapEntryAdapter();
        }
        return this.eStringToStringMapEntryItemProvider;
    }

    protected Adapter doCreateEStringToStringMapEntryAdapter() {
        return new EStringToStringMapEntryItemProvider((AdapterFactory)this);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.ecoreItemProviderAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        throw new UnsupportedOperationException("This factory must not be directly a child in a composed adapter factory");
    }

    public void setParentAdapterFactory(EcoreItemProviderAdapterFactory ecoreItemProviderAdapterFactory) {
        this.ecoreItemProviderAdapterFactory = ecoreItemProviderAdapterFactory;
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || type == EcorePackage.eINSTANCE;
    }

    protected Adapter createAdapter(Notifier target) {
        return (Adapter)this.modelSwitch.doSwitch((EObject)target);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter instanceof IDisposable) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        this.ecoreItemProviderAdapterFactory.fireNotifyChanged(notification);
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(EObject eObject, EAnnotation eAnnotation, ResourceLocator resourceLocator) {
        ArrayList<DecategorizingItemPropertyDescritorDecorator> result = new ArrayList<DecategorizingItemPropertyDescritorDecorator>();
        EClass eClass = eObject.eClass();
        Map properties = this.assistant.getApplicableProperties(eObject, eAnnotation);
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eAnnotation);
        for (Map.Entry entry : properties.entrySet()) {
            IItemPropertyDescriptor propertyDescriptor;
            String key = (String)entry.getKey();
            EStructuralFeature eStructuralFeature = (EStructuralFeature)entry.getValue();
            if (!eAllStructuralFeatures.contains((Object)eStructuralFeature) || (propertyDescriptor = this.getPropertyDescriptor(eObject, key, eStructuralFeature, eAnnotation, resourceLocator)) == null) continue;
            IItemPropertyDescriptor decoratedPropertyDescriptor = this.createPropertyDescriptorDecorator(propertyDescriptor, eObject, key, eStructuralFeature, eAnnotation, resourceLocator, domain);
            result.add(new DecategorizingItemPropertyDescritorDecorator(eObject, decoratedPropertyDescriptor));
        }
        return Collections.unmodifiableList(result);
    }

    public IItemPropertyDescriptor getPropertyDescriptor(EObject eObject, String key, EStructuralFeature eStructuralFeature, EAnnotation eAnnotation, ResourceLocator resourceLocator) {
        IItemPropertySource itemPropertySource = (IItemPropertySource)this.getRootAdapterFactory().adapt((Notifier)eObject, IItemPropertySource.class);
        return itemPropertySource == null ? null : itemPropertySource.getPropertyDescriptor((Object)eObject, (Object)eStructuralFeature);
    }

    public IItemPropertyDescriptor createPropertyDescriptorDecorator(IItemPropertyDescriptor propertyDescriptor, EObject eObject, String key, EStructuralFeature eStructuralFeature, EAnnotation eAnnotation, ResourceLocator resourceLocator, EditingDomain domain) {
        return new ModeledItemPropertyDescriptorDecorator(propertyDescriptor, eObject, key, eStructuralFeature, eAnnotation, resourceLocator, domain, this.getAssistant());
    }

    public String getGroupName(EObject instance) {
        String groupName = this.getResourceLocator().getString("_UI_" + instance.eClass().getName() + "_type");
        return groupName;
    }

    public static final class DecategorizingItemPropertyDescritorDecorator
    extends ItemPropertyDescriptorDecorator {
        public DecategorizingItemPropertyDescritorDecorator(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public String getCategory(Object thisObject) {
            return null;
        }

        public String getCategory() {
            return super.getCategory(this.object);
        }
    }

    public static interface Factory {
        public EAnnotationItemProviderAdapterFactory createEAnnotationItemProviderAdapterFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Group
    implements IItemPropertySource {
        protected Object propertyValue;
        protected final List<IItemPropertyDescriptor> itemPropertyDescriptors = new ArrayList<IItemPropertyDescriptor>();

        public Group(Object propertyValue) {
            this.propertyValue = propertyValue;
        }

        public void add(IItemPropertyDescriptor propertyDescriptor) {
            this.itemPropertyDescriptors.add(propertyDescriptor);
        }

        public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
            return this.itemPropertyDescriptors;
        }

        public List<IItemPropertyDescriptor> getPropertyDescriptors() {
            return this.itemPropertyDescriptors;
        }

        public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyID) {
            for (IItemPropertyDescriptor itemPropertyDescriptor : this.getPropertyDescriptors(object)) {
                if (!propertyID.equals(itemPropertyDescriptor.getId(object)) && !propertyID.equals(itemPropertyDescriptor.getFeature(object))) continue;
                return itemPropertyDescriptor;
            }
            return null;
        }

        public Object getEditableValue(Object object) {
            return this.propertyValue;
        }

        public String toString() {
            return this.propertyValue == null ? "null" : this.propertyValue.toString();
        }
    }

    public static class ModeledItemPropertyDescriptorDecorator
    extends ItemPropertyDescriptorDecorator {
        protected final String key;
        protected final EStructuralFeature eStructuralFeature;
        protected final EAnnotation eAnnotation;
        protected final EditingDomain domain;
        protected final BasicEAnnotationValidator.Assistant assistant;

        public ModeledItemPropertyDescriptorDecorator(IItemPropertyDescriptor propertyDescriptor, EObject eObject, String key, EStructuralFeature eStructuralFeature, EAnnotation eAnnotation, ResourceLocator resourceLocator, EditingDomain domain, BasicEAnnotationValidator.Assistant assistant) {
            super((Object)eObject, propertyDescriptor);
            this.key = key;
            this.eStructuralFeature = eStructuralFeature;
            this.eAnnotation = eAnnotation;
            this.domain = domain;
            this.assistant = assistant;
        }

        public boolean canSetProperty(Object object) {
            Resource resource = this.eAnnotation.eResource();
            return resource != null && !this.domain.isReadOnly(resource);
        }

        public boolean isPropertySet(Object thisObject) {
            EMap details = this.eAnnotation.getDetails();
            return details.get((Object)this.key) != null;
        }

        public boolean isPropertyUnsettable(Object object) {
            EMap details = this.eAnnotation.getDetails();
            return details.get((Object)this.key) == null && this.getPropertyValue(object) != null;
        }

        public void resetPropertyValue(Object thisObject) {
            EMap details = this.eAnnotation.getDetails();
            for (Map.Entry entry : details) {
                if (!this.key.equals(entry.getKey())) continue;
                this.domain.getCommandStack().execute(RemoveCommand.create((EditingDomain)this.domain, (Object)this.eAnnotation, (Object)EcorePackage.Literals.EANNOTATION__DETAILS, (Object)entry));
                return;
            }
        }

        public void setPropertyValue(Object object, Object value) {
            Object entry2;
            String literal = this.assistant.convertPropertyValueToLiteral((EObject)this.object, this.eStructuralFeature, value);
            EMap details = this.eAnnotation.getDetails();
            for (Object entry2 : details) {
                if (!this.key.equals(entry2.getKey())) continue;
                String entryValue = (String)entry2.getValue();
                if (entryValue == null ? literal != null : !entryValue.equals(literal)) {
                    this.domain.getCommandStack().execute(SetCommand.create((EditingDomain)this.domain, (Object)entry2, (Object)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, (Object)literal));
                }
                return;
            }
            entry2 = EcoreUtil.create((EClass)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY);
            entry2.eSet((EStructuralFeature)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__KEY, (Object)this.key);
            entry2.eSet((EStructuralFeature)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, (Object)literal);
            this.domain.getCommandStack().execute(AddCommand.create((EditingDomain)this.domain, (Object)this.eAnnotation, (Object)EcorePackage.Literals.EANNOTATION__DETAILS, (Object)entry2));
        }
    }

    public static class Reflective
    extends EAnnotationItemProviderAdapterFactory {
        private static BasicEAnnotationValidator.Assistant getAssistant(String annotationSource) {
            EAnnotationValidator eAnnotationValidator = EAnnotationValidator.Registry.INSTANCE.getEAnnotationValidator(annotationSource);
            if (eAnnotationValidator instanceof BasicEAnnotationValidator) {
                return ((BasicEAnnotationValidator)eAnnotationValidator).getAssistant();
            }
            throw new RuntimeException("There is no BasicEAnnotationValidator validator registered for " + annotationSource);
        }

        public Reflective(String annotationSource) {
            super((ResourceLocator)EcoreEditPlugin.INSTANCE, Reflective.getAssistant(annotationSource));
        }

        public String getGroupName(EObject instance) {
            return NameHelper.INSTANCE.getTypeText(instance);
        }

        private static class NameHelper
        extends ReflectiveItemProvider {
            private static final NameHelper INSTANCE = new NameHelper();

            private NameHelper() {
                super(null);
            }

            public String getTypeText(Object object) {
                return super.getTypeText(object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry
    extends Map<String, Factory> {
        public static final Registry INSTANCE = new Impl();

        public EAnnotationItemProviderAdapterFactory createEAnnotationItemProviderAdapterFactory(String var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Impl
        extends HashMap<String, Factory>
        implements Registry {
            private static final long serialVersionUID = 1L;

            @Override
            public EAnnotationItemProviderAdapterFactory createEAnnotationItemProviderAdapterFactory(String annotationSource) {
                Factory factory = (Factory)this.get(annotationSource);
                return factory == null ? null : factory.createEAnnotationItemProviderAdapterFactory();
            }
        }
    }
}

