/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ContainerGenerator {
    private IPath containerFullPath;
    private IContainer container;

    public ContainerGenerator(IPath containerPath) {
        this.containerFullPath = containerPath;
    }

    private IFolder createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        folderHandle.create(false, true, monitor);
        return folderHandle;
    }

    private IFolder createFolderHandle(IContainer container, String folderName) {
        return container.getFolder((IPath)new Path(folderName));
    }

    private IProject createProject(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        projectHandle.create((IProgressMonitor)subMonitor.split(1));
        projectHandle.open((IProgressMonitor)subMonitor.split(1));
        return projectHandle;
    }

    private IProject createProjectHandle(IWorkspaceRoot root, String projectName) {
        return root.getProject(projectName);
    }

    public IContainer generateContainer(IProgressMonitor monitor) throws CoreException {
        IDEWorkbenchPlugin.getPluginWorkspace().run(monitor1 -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor1, (String)IDEWorkbenchMessages.ContainerGenerator_progressMessage, (int)this.containerFullPath.segmentCount());
            if (this.container != null) {
                return;
            }
            IWorkspaceRoot root = this.getWorkspaceRoot();
            this.container = (IContainer)root.findMember(this.containerFullPath);
            if (this.container != null) {
                return;
            }
            this.container = root;
            int i = 0;
            while (i < this.containerFullPath.segmentCount()) {
                String currentSegment = this.containerFullPath.segment(i);
                IResource resource = this.container.findMember(currentSegment);
                if (resource != null) {
                    if (resource.getType() == 1) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.ContainerGenerator_pathOccupied, (Object)resource.getFullPath().makeRelative());
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.ide", 1, msg, null));
                    }
                    this.container = (IContainer)resource;
                    subMonitor.worked(1);
                } else if (i == 0) {
                    IProject projectHandle = this.createProjectHandle(root, currentSegment);
                    this.container = this.createProject(projectHandle, (IProgressMonitor)subMonitor.split(1));
                } else {
                    IFolder folderHandle = this.createFolderHandle(this.container, currentSegment);
                    this.container = this.createFolder(folderHandle, (IProgressMonitor)subMonitor.split(1));
                }
                ++i;
            }
        }, null, 0, monitor);
        return this.container;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
    }
}

