/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TypePattern
extends Pattern {
    public LocalDeclaration local;

    public TypePattern(LocalDeclaration local) {
        this.local = local;
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] variables, BlockScope scope) {
        if (this.resolvedType == null) {
            this.resolveType(scope);
        }
        if (this.local != null && this.local.binding != null) {
            if (this.patternVarsWhenTrue == null) {
                this.patternVarsWhenTrue = new LocalVariableBinding[1];
                this.patternVarsWhenTrue[0] = this.local.binding;
            } else {
                this.addPatternVariablesWhenTrue(new LocalVariableBinding[]{this.local.binding});
            }
        }
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo.markAsDefinitelyAssigned(this.local.binding);
        if (!this.isTotalTypeNode) {
            flowInfo.markAsDefinitelyNonNull(this.local.binding);
        } else if (flowContext.associatedNode instanceof SwitchStatement) {
            SwitchStatement swStmt = (SwitchStatement)flowContext.associatedNode;
            int nullStatus = swStmt.containsNull ? 4 : swStmt.expression.nullStatus(flowInfo, flowContext);
            flowInfo.markNullStatus(this.local.binding, nullStatus);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if (this.local != null) {
            LocalVariableBinding localBinding = this.local.binding;
            if (!this.isTotalTypeNode) {
                codeStream.checkcast(localBinding.type);
            }
            this.local.generateCode(currentScope, codeStream);
            codeStream.store(localBinding, false);
            localBinding.recordInitializationStartPC(codeStream.position);
        }
    }

    @Override
    public LocalDeclaration getPatternVariableIntroduced() {
        return this.local;
    }

    @Override
    public void resolve(BlockScope scope) {
        this.resolveType(scope);
    }

    @Override
    public boolean isTotalForType(TypeBinding type) {
        if (type == null || this.resolvedType == null) {
            return false;
        }
        return type.erasure().isSubtypeOf(this.resolvedType.erasure(), false);
    }

    @Override
    public boolean dominates(Pattern p) {
        return this.isTotalForType(p.resolvedType);
    }

    @Override
    public TypeBinding resolveAtType(BlockScope scope, TypeBinding u) {
        if (this.resolvedType == null) {
            this.resolvedType = this.local.binding.type;
        }
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.resolvedType != null || this.local == null) {
            return this.resolvedType;
        }
        this.local.modifiers |= 0x10000000;
        this.local.resolve(scope, true);
        if (this.local.binding != null) {
            this.local.binding.modifiers |= 0x10000000;
            this.local.binding.useFlag = 1;
            this.resolvedType = this.local.binding.type;
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.local != null) {
            this.local.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.local != null ? this.local.printAsExpression(indent, output) : output;
    }
}

