/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ResourceURICollector {
    private static final Logger LOG = Logger.getLogger(ResourceURICollector.class);

    public Set<URI> collectAllResources(Iterable<URI> roots, Set<String> fileExtensions) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Collecting source models.");
        }
        long startedAt = System.currentTimeMillis();
        Set<URI> result = this.collectResources(roots, fileExtensions);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished collecting source models. Took: " + (System.currentTimeMillis() - startedAt) + " ms."));
        }
        return result;
    }

    protected Set<URI> collectResources(Iterable<URI> roots, Set<String> fileExtensions) {
        HashSet<String> extensions = new HashSet<String>(fileExtensions);
        extensions.add("java");
        List paths = StreamSupport.stream(roots.spliterator(), false).map(URI::toFileString).collect(Collectors.toList());
        Multimap modelsFound = new PathTraverser().resolvePathes(paths, uri -> extensions.contains(uri.fileExtension()));
        modelsFound.asMap().forEach((path, resource) -> {
            File file = new File((String)path);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        });
        return IterableExtensions.toSet((Iterable)modelsFound.values());
    }

    protected void registerBundle(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return;
            }
            String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            if (name != null) {
                int indexOf = name.indexOf(";");
                if (indexOf > 0) {
                    name = name.substring(0, indexOf);
                }
                if (EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                    return;
                }
                String path = "archive:" + URI.createFileURI((String)file.getAbsolutePath()) + "!/";
                EcorePlugin.getPlatformResourceMap().put(name, URI.createURI((String)path));
            }
        }
        catch (ZipException e) {
            LOG.info((Object)("Could not open Jar file " + file.getAbsolutePath() + "."));
        }
        catch (Exception e) {
            LOG.error((Object)file.getAbsolutePath(), (Throwable)e);
        }
    }
}

