/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherColorRef;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.FillStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public final class HSLFFill {
    private static final POILogger LOG = POILogFactory.getLogger(HSLFFill.class);
    static final int FILL_SOLID = 0;
    static final int FILL_PATTERN = 1;
    static final int FILL_TEXTURE = 2;
    static final int FILL_PICTURE = 3;
    static final int FILL_SHADE = 4;
    static final int FILL_SHADE_CENTER = 5;
    static final int FILL_SHADE_SHAPE = 6;
    static final int FILL_SHADE_SCALE = 7;
    static final int FILL_SHADE_TITLE = 8;
    static final int FILL_BACKGROUND = 9;
    private static final BitField FILL_USE_RECOLOR_FILL_AS_PICTURE = BitFieldFactory.getInstance(0x400000);
    private static final BitField FILL_USE_USE_SHAPE_ANCHOR = BitFieldFactory.getInstance(0x200000);
    private static final BitField FILL_USE_FILLED = BitFieldFactory.getInstance(0x100000);
    private static final BitField FILL_USE_HIT_TEST_FILL = BitFieldFactory.getInstance(524288);
    private static final BitField FILL_USE_FILL_SHAPE = BitFieldFactory.getInstance(262144);
    private static final BitField FILL_USE_FILL_USE_RECT = BitFieldFactory.getInstance(131072);
    private static final BitField FILL_USE_NO_FILL_HIT_TEST = BitFieldFactory.getInstance(65536);
    private static final BitField FILL_RECOLOR_FILL_AS_PICTURE = BitFieldFactory.getInstance(64);
    private static final BitField FILL_USE_SHAPE_ANCHOR = BitFieldFactory.getInstance(32);
    private static final BitField FILL_FILLED = BitFieldFactory.getInstance(16);
    private static final BitField FILL_HIT_TEST_FILL = BitFieldFactory.getInstance(8);
    private static final BitField FILL_FILL_SHAPE = BitFieldFactory.getInstance(4);
    private static final BitField FILL_FILL_USE_RECT = BitFieldFactory.getInstance(2);
    private static final BitField FILL_NO_FILL_HIT_TEST = BitFieldFactory.getInstance(1);
    private HSLFShape shape;

    public HSLFFill(HSLFShape shape) {
        this.shape = shape;
    }

    public FillStyle getFillStyle() {
        return new FillStyle(){

            @Override
            public PaintStyle getPaint() {
                int fillType = HSLFFill.this.getFillType();
                switch (fillType) {
                    case 0: {
                        return DrawPaint.createSolidPaint(HSLFFill.this.getForegroundColor());
                    }
                    case 6: {
                        return HSLFFill.this.getGradientPaint(PaintStyle.GradientPaint.GradientType.shape);
                    }
                    case 5: 
                    case 8: {
                        return HSLFFill.this.getGradientPaint(PaintStyle.GradientPaint.GradientType.circular);
                    }
                    case 4: 
                    case 7: {
                        return HSLFFill.this.getGradientPaint(PaintStyle.GradientPaint.GradientType.linear);
                    }
                    case 3: {
                        return HSLFFill.this.getTexturePaint();
                    }
                }
                LOG.log(5, "unsuported fill type: " + fillType);
                return null;
            }
        };
    }

    private PaintStyle.GradientPaint getGradientPaint(final PaintStyle.GradientPaint.GradientType gradientType) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        final EscherArrayProperty ep = (EscherArrayProperty)HSLFShape.getEscherProperty(opt, 407);
        final int colorCnt = ep == null ? 0 : ep.getNumberOfElementsInArray();
        opt = (AbstractEscherOptRecord)this.shape.getEscherChild(RecordTypes.EscherUserDefined);
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447);
        int propVal = p == null ? 0 : p.getPropertyValue();
        final boolean rotateWithShape = FILL_USE_USE_SHAPE_ANCHOR.isSet(propVal) && FILL_USE_SHAPE_ANCHOR.isSet(propVal);
        return new PaintStyle.GradientPaint(){

            @Override
            public double getGradientAngle() {
                int rot = HSLFFill.this.shape.getEscherProperty((short)395);
                return 90.0 - Units.fixedPointToDouble(rot);
            }

            @Override
            public ColorStyle[] getGradientColors() {
                ColorStyle[] cs;
                if (colorCnt == 0) {
                    cs = new ColorStyle[]{this.wrapColor(HSLFFill.this.getBackgroundColor()), this.wrapColor(HSLFFill.this.getForegroundColor())};
                } else {
                    cs = new ColorStyle[colorCnt];
                    int idx = 0;
                    for (byte[] data : ep) {
                        EscherColorRef ecr = new EscherColorRef(data, 0, 4);
                        cs[idx++] = this.wrapColor(HSLFFill.this.shape.getColor(ecr));
                    }
                }
                return cs;
            }

            private ColorStyle wrapColor(Color col) {
                return col == null ? null : DrawPaint.createSolidPaint(col).getSolidColor();
            }

            @Override
            public float[] getGradientFractions() {
                float[] frc;
                if (colorCnt == 0) {
                    frc = new float[]{0.0f, 1.0f};
                } else {
                    frc = new float[colorCnt];
                    int idx = 0;
                    for (byte[] data : ep) {
                        double pos = Units.fixedPointToDouble(LittleEndian.getInt(data, 4));
                        frc[idx++] = (float)pos;
                    }
                }
                return frc;
            }

            @Override
            public boolean isRotatedWithShape() {
                return rotateWithShape;
            }

            @Override
            public PaintStyle.GradientPaint.GradientType getGradientType() {
                return gradientType;
            }
        };
    }

    private PaintStyle.TexturePaint getTexturePaint() {
        final HSLFPictureData pd = this.getPictureData();
        if (pd == null) {
            return null;
        }
        return new PaintStyle.TexturePaint(){

            @Override
            public InputStream getImageData() {
                return new ByteArrayInputStream(pd.getData());
            }

            @Override
            public String getContentType() {
                return pd.getContentType();
            }

            @Override
            public int getAlpha() {
                return (int)(HSLFFill.this.shape.getAlpha((short)386) * 100000.0);
            }
        };
    }

    public int getFillType() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 384);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    void afterInsert(HSLFSheet sh) {
        int idx;
        EscherBSERecord bse;
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 390);
        if (p != null && (bse = this.getEscherBSERecord(idx = p.getPropertyValue())) != null) {
            bse.setRef(bse.getRef() + 1);
        }
    }

    EscherBSERecord getEscherBSERecord(int idx) {
        HSLFSheet sheet = this.shape.getSheet();
        if (sheet == null) {
            LOG.log(1, "Fill has not yet been assigned to a sheet");
            return null;
        }
        HSLFSlideShow ppt = sheet.getSlideShow();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)HSLFShape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            LOG.log(1, "EscherContainerRecord.BSTORE_CONTAINER was not found ");
            return null;
        }
        List<EscherRecord> lst = bstore.getChildRecords();
        return (EscherBSERecord)lst.get(idx - 1);
    }

    public void setFillType(int type) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(opt, (short)384, type);
    }

    public Color getForegroundColor() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447);
        int propVal = p == null ? 0 : p.getPropertyValue();
        return FILL_USE_FILLED.isSet(propVal) && !FILL_FILLED.isSet(propVal) ? null : this.shape.getColor((short)385, (short)386);
    }

    public void setForegroundColor(Color color) {
        EscherSimpleProperty p;
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        opt.removeEscherProperty(386);
        opt.removeEscherProperty(385);
        if (color != null) {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(opt, (short)385, rgb);
            int alpha = color.getAlpha();
            if (alpha < 255) {
                int alphaFP = Units.doubleToFixedPoint((double)alpha / 255.0);
                HSLFShape.setEscherProperty(opt, (short)386, alphaFP);
            }
        }
        int propVal = (p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447)) == null ? 0 : p.getPropertyValue();
        propVal = FILL_FILLED.setBoolean(propVal, color != null);
        propVal = FILL_NO_FILL_HIT_TEST.setBoolean(propVal, color != null);
        propVal = FILL_USE_FILLED.set(propVal);
        propVal = FILL_USE_FILL_SHAPE.set(propVal);
        propVal = FILL_USE_NO_FILL_HIT_TEST.set(propVal);
        propVal = FILL_FILL_SHAPE.clear(propVal);
        HSLFShape.setEscherProperty(opt, (short)447, propVal);
    }

    public Color getBackgroundColor() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 447);
        int propVal = p == null ? 0 : p.getPropertyValue();
        return FILL_USE_FILLED.isSet(propVal) && !FILL_FILLED.isSet(propVal) ? null : this.shape.getColor((short)387, (short)386);
    }

    public void setBackgroundColor(Color color) {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        if (color == null) {
            HSLFShape.setEscherProperty(opt, (short)387, -1);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(opt, (short)387, rgb);
        }
    }

    public HSLFPictureData getPictureData() {
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFShape.getEscherProperty(opt, 390);
        if (p == null) {
            return null;
        }
        HSLFSlideShow ppt = this.shape.getSheet().getSlideShow();
        List<HSLFPictureData> pict = ppt.getPictureData();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)HSLFShape.getEscherChild(dggContainer, -4095);
        List<EscherRecord> lst = bstore.getChildRecords();
        int idx = p.getPropertyValue();
        if (idx == 0) {
            LOG.log(5, "no reference to picture data found ");
        } else {
            EscherBSERecord bse = (EscherBSERecord)lst.get(idx - 1);
            for (HSLFPictureData pd : pict) {
                if (pd.getOffset() != bse.getOffset()) continue;
                return pd;
            }
        }
        return null;
    }

    public void setPictureData(HSLFPictureData data) {
        EscherBSERecord bse;
        AbstractEscherOptRecord opt = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(opt, (short)16774, data == null ? 0 : data.getIndex());
        if (data != null && this.shape.getSheet() != null && (bse = this.getEscherBSERecord(data.getIndex())) != null) {
            bse.setRef(bse.getRef() + 1);
        }
    }
}

