/*
 * Copyright (c) 2017 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import java.lang.Iterable;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import org.eclipse.collections.api.tuple.primitive.BooleanObjectPair;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanList extends MutableBooleanCollection, BooleanList
{
    void addAtIndex(int index, boolean element);

    boolean addAllAtIndex(int index, boolean... source);

    boolean addAllAtIndex(int index, BooleanIterable source);

    boolean removeAtIndex(int index);

    boolean set(int index, boolean element);

    @Override
    MutableBooleanList select(BooleanPredicate predicate);

    @Override
    MutableBooleanList reject(BooleanPredicate predicate);

    @Override
    MutableBooleanList with(boolean element);

    @Override
    MutableBooleanList without(boolean element);

    @Override
    MutableBooleanList withAll(BooleanIterable elements);

    @Override
    MutableBooleanList withoutAll(BooleanIterable elements);

    /**
     * @since 9.0.
     */
    @Override
    default MutableBooleanList tap(BooleanProcedure procedure)
    {
        this.forEach(procedure);
        return this;
    }

    <V> MutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    /**
     * Returns a new MutableList using results obtained by applying the specified function to each element
     * and its corresponding index.
     *
     * @since 9.1.
     */
    @Override
    default <V> MutableList<V> collectWithIndex(BooleanIntToObjectFunction<? extends V> function)
    {
        int[] index = { 0 };
        return this.collect(each -> function.value(each, index[0]++));
    }

    MutableBooleanList reverseThis();

    @Override
    MutableBooleanList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    MutableBooleanList distinct();

    @Override
    MutableBooleanList asUnmodifiable();

    @Override
    MutableBooleanList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    @Override
    ImmutableBooleanList toImmutable();

    @Override
    MutableBooleanList subList(int fromIndex, int toIndex);

    /**
     * Returns a {@code MutableList} formed from this {@code MutableBooleanList} and another {@code BooleanList} by
     * combining corresponding elements in pairs. If one of the two {@code BooleanList}s is longer than the other, its
     * remaining elements are ignored.
     *
     * @since 9.1.
     */
    default MutableList<BooleanBooleanPair> zipBoolean(BooleanIterable iterable)
    {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    /**
     * Returns a {@code MutableList} formed from this {@code MutableBooleanList} and a {@code ListIterable} by
     * combining corresponding elements in pairs. If one of the two Lists is longer than the other, its
     * remaining elements are ignored.
     *
     * @since 9.1.
     */
    default <T> MutableList<BooleanObjectPair<T>> zip(Iterable<T> list)
    {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }
}
