/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of {@link org.eclipse.collections.api.set.sorted.ImmutableSortedSet}.
 * <p>
 *     This package contains the following immutable sorted set implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.immutable.ImmutableEmptySortedSet} -  a zero element {@link org.eclipse.collections.api.set.sorted.ImmutableSortedSet}.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.immutable.ImmutableTreeSet} - the non-modifiable equivalent of {@link org.eclipse.collections.api.set.sorted.MutableSortedSet}.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.sorted.immutable.ImmutableSortedSetFactoryImpl} -  a factory which creates instances of type {@link org.eclipse.collections.api.set.sorted.ImmutableSortedSet}
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.set.sorted.immutable;
