/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.comparator.primitive.LongComparator;
import org.eclipse.collections.api.block.function.primitive.LongIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;

public interface MutableLongList
extends MutableLongCollection,
LongList {
    public void addAtIndex(int var1, long var2);

    public boolean addAllAtIndex(int var1, long ... var2);

    public boolean addAllAtIndex(int var1, LongIterable var2);

    public long removeAtIndex(int var1);

    public long set(int var1, long var2);

    default public void swap(int index1, int index2) {
        long value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableLongList select(LongPredicate var1);

    @Override
    public MutableLongList reject(LongPredicate var1);

    @Override
    public MutableLongList with(long var1);

    @Override
    public MutableLongList without(long var1);

    @Override
    public MutableLongList withAll(LongIterable var1);

    @Override
    public MutableLongList withoutAll(LongIterable var1);

    @Override
    default public MutableLongList tap(LongProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(LongIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((long each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableLongList reverseThis();

    @Override
    public MutableLongList toReversed();

    @Override
    public MutableLongList distinct();

    public MutableLongList sortThis();

    default public MutableLongList sortThis(LongComparator comparator) {
        throw new UnsupportedOperationException("sortThis(LongComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableLongList sortThisBy(LongToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableLongList sortThisBy(LongToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableLongList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableLongList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            long selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableLongList asUnmodifiable();

    @Override
    public MutableLongList asSynchronized();

    @Override
    public ImmutableLongList toImmutable();

    @Override
    public MutableLongList subList(int var1, int var2);

    default public MutableList<LongLongPair> zipLong(LongIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<LongObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableLongList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

