/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageList;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.uml2.uml.Element;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.resourcelistener.ResourceSetListenerExtra;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.NotificationManager;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.validator.managers.DiagramChecker;
import org.polarsys.chess.validator.managers.ModelManager;
import org.polarsys.chess.validator.managers.ModelParser;

public class ResourceListener
extends ResourceSetListenerExtra {
    private StringBuffer errorMessage = new StringBuffer();
    private DiagramChecker diagramChecker = DiagramChecker.loadDiagramChecker();
    private ModelManager automatedActionManager = null;
    private ModelParser modelparser = null;
    private static Class[] allowedNotifierTypes = new Class[]{Element.class, DynamicEObjectImpl.class, Diagram.class, PageList.class, Shape.class, EAnnotation.class, EObject.class};

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List list = event.getNotifications();
        CompoundCommand command = new CompoundCommand();
        DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((ServicesRegistry)this.sr);
        if (ds == null) {
            return command;
        }
        if (!ds.isUserAction()) {
            // empty if block
        }
        for (Notification notif : list) {
            if (notif instanceof ENotificationImpl) {
                PageRef ref;
                ENotificationImpl notification = (ENotificationImpl)notif;
                Object notifier = notification.getNotifier();
                if (this.isNotationElement(notifier) || !this.allowedNotifier(notifier)) continue;
                this.initErrorMessage(notification);
                if (notifier instanceof Element || notifier instanceof DynamicEObjectImpl || this.canBeStaticStereotype(notifier)) continue;
                if (notifier instanceof Shape) {
                    if (notification.getNewValue() instanceof EObject) continue;
                    continue;
                }
                if (notifier instanceof EAnnotation || !(notifier instanceof PageList) || !(notification.getNewValue() instanceof PageRef) || !((ref = (PageRef)notification.getNewValue()).getEmfPageIdentifier() instanceof Diagram)) continue;
                this.performDiagramChecker(event, ds, (Diagram)ref.getEmfPageIdentifier());
                continue;
            }
            Object newz = notif.getNewValue();
            if (!(newz instanceof Diagram)) continue;
            this.performDiagramChecker(event, ds, (Diagram)newz);
        }
        return command.getCommandList().isEmpty() ? super.transactionAboutToCommit(event) : command;
    }

    private void performEAnnotationChecker(Object notifier) throws RollbackException {
        EAnnotation annotation = (EAnnotation)notifier;
        System.out.println("ANN: " + annotation);
        EMap details = annotation.getDetails();
        for (Map.Entry entry : details) {
            if (((String)entry.getValue()).indexOf("DeploymentView") <= 0 && ((String)entry.getValue()).indexOf("ComponentView") <= 0 && ((String)entry.getValue()).indexOf("AnalysisView") <= 0 && ((String)entry.getValue()).indexOf("DependabilityAnalysisView") <= 0 && ((String)entry.getValue()).indexOf("RTAnalysisView") <= 0 && ((String)entry.getValue()).indexOf("TimingDataFlowView") <= 0) continue;
            this.errorMessage.delete(0, this.errorMessage.length());
            this.errorMessage.append("Can't apply view stereotype!");
            CHESSProjectSupport.printlnToCHESSConsole((String)this.errorMessage.toString());
            ResourceNotification.showError((String)this.errorMessage.toString());
            throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", this.errorMessage.toString()));
        }
    }

    private void addShapeInfoErrorMessage(Object notifier) {
        Shape shape = (Shape)notifier;
        this.errorMessage.append(" shape modified: ");
        this.errorMessage.append(" for the element: ");
        this.errorMessage.append(shape.getElement());
        if (shape.getElement() != null) {
            this.errorMessage.append(" that belong to the view: ");
            this.errorMessage.append(shape.getElement().eContainer());
        }
        if (shape.getDiagram() != null) {
            this.errorMessage.append(" in the diagram: ");
            this.errorMessage.append(shape.getDiagram().getName());
            this.errorMessage.append(" in the view: ");
            this.errorMessage.append(shape.getDiagram().getElement());
        }
    }

    private void initErrorMessage(ENotificationImpl notification) {
        this.errorMessage.delete(0, this.errorMessage.length());
        this.errorMessage.append("R.");
        this.errorMessage.append(NotificationManager.printEventType((Notification)notification));
    }

    private void performDiagramChecker(ResourceSetChangeEvent event, DiagramStatus ds, Diagram diagram) throws RollbackException {
        this.diagramChecker.check(diagram, this.errorMessage, ds.getCurrentView(), event.getEditingDomain());
    }

    private void performAutomatedActionChecker(ResourceSetChangeEvent event, List<Notification> list, DiagramStatus ds, CompoundCommand command, ENotificationImpl notification, Object notifier) throws RollbackException {
        try {
            Command comm = this.automatedActionManager.check(list, (Notification)notification, notifier, this.errorMessage, ds, event.getEditingDomain());
            if (comm != null) {
                ds.setUserAction(false);
                command.append(comm);
                System.out.println("COMMAND: " + comm.getLabel());
                System.out.println("SUPERUSER set to true");
            }
        }
        catch (RollbackException e) {
            this.errorMessage.delete(0, this.errorMessage.length());
            this.errorMessage.append(e.getStatus().getMessage());
            ResourceNotification.showInfo((String)e.getStatus().getMessage());
            throw e;
        }
    }

    private void performModelParserChecker(DiagramStatus ds, boolean executeModelParser, ENotificationImpl notification, Object notifier) throws RollbackException {
        try {
            if (executeModelParser) {
                this.modelparser.check((Notification)notification, notifier, ds.getCurrentView(), ds.isSuperuser());
            }
        }
        catch (RollbackException e) {
            ResourceNotification.showInfo((String)e.getStatus().getMessage());
            throw e;
        }
    }

    private void printList(List<Notification> list) {
        System.out.println("----------------------------------");
        int j = 0;
        for (Notification notif1 : list) {
            ENotificationImpl notification;
            Object notifier;
            ++j;
            if (!(notif1 instanceof ENotificationImpl) || this.isNotationElement(notifier = (notification = (ENotificationImpl)notif1).getNotifier())) continue;
            System.out.println("ACTION " + j + " OF " + list.size());
            System.out.println("TYPE: " + NotificationManager.printEventType((Notification)notification));
            System.out.println("NOTIFIER: " + notifier);
            System.out.println("FEATURE: " + notification.getFeature());
            if (notification.getEventType() == 4) {
                System.out.println("OLDVALUE: " + notification.getOldValue());
                continue;
            }
            if (notification.getEventType() == 3) {
                System.out.println("NEWVALUE: " + notification.getNewValue());
                continue;
            }
            System.out.println("OLDVALUE: " + notification.getOldValue());
            System.out.println("NEWVALUE: " + notification.getNewValue());
        }
        System.out.println("----------------------------------");
    }

    private boolean isNotationElement(Object notifier) {
        String pkgName;
        return notifier instanceof EObject && (pkgName = notifier.getClass().getPackage().getName()).startsWith("org.eclipse.gmf.runtime.notation");
    }

    private boolean canBeStaticStereotype(Object notifier) {
        if (notifier instanceof EObject) {
            String pkgName = notifier.getClass().getPackage().getName();
            if (pkgName.startsWith("org.eclipse.papyrus.MARTE") || pkgName.startsWith("org.polarsys.chess.chessmlprofile")) {
                return true;
            }
            return !(notifier instanceof EAnnotation) && !(notifier instanceof Shape);
        }
        return false;
    }

    private boolean allowedNotifier(Object notifier) {
        Class[] classArray = allowedNotifierTypes;
        int n = allowedNotifierTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class allowedType = classArray[n2];
            if (allowedType.isInstance(notifier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

