/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.polarsys.chess.patterns.dialogs.MappingLabelProvider;
import org.polarsys.chess.patterns.dialogs.QNameLabelProvider;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;

public abstract class AbstractMappingDialog
extends TitleAreaDialog {
    public static final int BACK = -1;
    protected Model chessModel;
    protected Pattern pattern;
    protected Class modelCtx;
    protected Map<NamedElement, NamedElement> mappings;
    protected NamedElement patternElem;
    protected NamedElement modelElem;
    protected List<NamedElement> candidates;
    private TableViewer patternElmentsTable;
    private TableViewer modelElementsTable;
    private MappingLabelProvider mapLabelProvider;
    private Button mapButton;
    private Button unMapButton;
    private Button clearMapButton;
    private Group patternPreviewGroup;
    private Label imageLabel;
    private Image patternPreview;

    public AbstractMappingDialog(Shell shell, Model chessModel, Class modelCtx, Pattern pattern, Image patternPreview) {
        super(shell);
        this.chessModel = chessModel;
        this.pattern = pattern;
        this.patternPreview = patternPreview;
        this.modelCtx = modelCtx;
        this.mappings = new HashMap<NamedElement, NamedElement>();
    }

    public void create() {
        this.setHelpAvailable(false);
        super.create();
        this.setTitle("Apply Design Pattern");
        this.getButton(0).setText("Next");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.widthHint = 400;
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 3;
        Group mappingGroup = new Group(parent, 2048);
        mappingGroup.setText("binding of pattern types");
        mappingGroup.setLayout((Layout)new GridLayout(1, false));
        mappingGroup.setLayoutData((Object)gd);
        this.patternElmentsTable = new TableViewer((Composite)mappingGroup, 2048);
        TableViewerColumn c1Viewer = new TableViewerColumn(this.patternElmentsTable, 16384);
        TableColumn column1 = c1Viewer.getColumn();
        column1.setText("Element");
        column1.setWidth(200);
        TableViewerColumn c2Viewer = new TableViewerColumn(this.patternElmentsTable, 16384);
        TableColumn column2 = c2Viewer.getColumn();
        column2.setText("Bound to");
        column2.setWidth(200);
        this.patternElmentsTable.getTable().setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 200;
        this.patternElmentsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        c1Viewer.setLabelProvider((CellLabelProvider)new MappingLabelProvider(1, this.mappings));
        this.mapLabelProvider = new MappingLabelProvider(2, this.mappings);
        c2Viewer.setLabelProvider((CellLabelProvider)this.mapLabelProvider);
        this.patternElmentsTable.getTable().setLayoutData((Object)data);
        this.patternElmentsTable.setInput((Object)this.getPatternInput().toArray());
        this.patternElmentsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = AbstractMappingDialog.this.patternElmentsTable.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof NamedElement) {
                    AbstractMappingDialog.this.patternElem = (NamedElement)selected[0];
                    AbstractMappingDialog.this.candidates.clear();
                    AbstractMappingDialog.this.updateCandidates();
                    AbstractMappingDialog.this.modelElementsTable.setInput((Object)AbstractMappingDialog.this.candidates.toArray());
                }
            }
        });
        this.mapButton = new Button(parent, 0);
        this.mapButton.setText("Create mapping");
        this.mapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMappingDialog.this.mappings.put(AbstractMappingDialog.this.patternElem, AbstractMappingDialog.this.modelElem);
                AbstractMappingDialog.this.patternElmentsTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.unMapButton = new Button(parent, 0);
        this.unMapButton.setText("Delete mapping");
        this.unMapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMappingDialog.this.mappings.put(AbstractMappingDialog.this.patternElem, null);
                AbstractMappingDialog.this.patternElmentsTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.clearMapButton = new Button(parent, 0);
        this.clearMapButton.setText("Clear all mappings");
        this.clearMapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (NamedElement patternType : AbstractMappingDialog.this.mappings.keySet()) {
                    if (AbstractMappingDialog.this.mappings.get(patternType) == null) continue;
                    AbstractMappingDialog.this.mappings.put(patternType, null);
                }
                AbstractMappingDialog.this.patternElmentsTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData buttonData = new GridData();
        this.mapButton.setLayoutData((Object)buttonData);
        this.unMapButton.setLayoutData((Object)buttonData);
        this.clearMapButton.setLayoutData((Object)buttonData);
        Group candidatesGroup = new Group(parent, 2048);
        candidatesGroup.setText("Available candidates for mapping from the model");
        candidatesGroup.setLayout((Layout)new GridLayout(1, false));
        candidatesGroup.setLayoutData((Object)gd);
        this.modelElementsTable = new TableViewer((Composite)candidatesGroup, 2048);
        this.modelElementsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.candidates = new ArrayList<NamedElement>();
        this.modelElementsTable.setInput((Object)this.candidates.toArray());
        this.modelElementsTable.getTable().setLayoutData((Object)data);
        this.modelElementsTable.setLabelProvider((IBaseLabelProvider)new QNameLabelProvider());
        this.modelElementsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = AbstractMappingDialog.this.modelElementsTable.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof NamedElement) {
                    AbstractMappingDialog.this.modelElem = (NamedElement)selected[0];
                }
            }
        });
        GridData gdPreview = new GridData();
        gdPreview.widthHint = 800;
        gdPreview.heightHint = 400;
        gdPreview.grabExcessVerticalSpace = true;
        gdPreview.grabExcessHorizontalSpace = true;
        gdPreview.horizontalAlignment = 4;
        gdPreview.verticalAlignment = 4;
        gdPreview.horizontalSpan = 3;
        this.patternPreviewGroup = new Group(parent, 2048);
        this.patternPreviewGroup.setText("Pattern Preview");
        this.patternPreviewGroup.setLayout((Layout)new FillLayout());
        this.patternPreviewGroup.setLayoutData((Object)gdPreview);
        this.imageLabel = new Label((Composite)this.patternPreviewGroup, 0x1000000);
        if (this.patternPreview != null) {
            this.imageLabel.setImage(this.patternPreview);
        } else {
            this.imageLabel.setText("preview not available");
            this.imageLabel.setImage(null);
        }
        return super.createDialogArea(parent);
    }

    protected abstract List<NamedElement> getPatternInput();

    protected abstract void updateCandidates();

    public Map<NamedElement, NamedElement> getMappings() {
        return this.mappings;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        if (14 == buttonId) {
            this.backPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void backPressed() {
        this.setReturnCode(-1);
        this.close();
    }
}

