/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.transformations;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Trace;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.mobius.Activator;
import org.polarsys.chess.mobius.model.SAN.SANModelPackage;

public class QVToTransformation {
    private static final String SELECTED_PLATFORM_PROPERTY = "selectedPlatformQName";
    private static final String SELECTED_ANALYSISCONTEXT_PROPERTY = "analysisContextQName";
    private static final String CHESS2SAN = "platform:/plugin/org.polarsys.chess.mobius/transformations/CHESS2SAN.qvto";
    boolean isChessUserAction;
    private DiagramEditPart diagramEditPart = null;
    private Resource sourceResource;
    private Resource targetResource;
    private boolean createNewModel = true;
    private IProgressMonitor monitor;
    private String selectedElement = null;
    private String analysisContextQN = null;

    public void performCHESS2SANTransformation(Resource chessResource, Resource sanResource, IProgressMonitor monitor, String selectedElement, String analysisContextQN) {
        SANModelPackage.eINSTANCE.getClass();
        this.sourceResource = chessResource;
        this.targetResource = sanResource;
        this.monitor = monitor;
        this.selectedElement = selectedElement;
        this.analysisContextQN = analysisContextQN;
        this.performTransformation(CHESS2SAN);
    }

    private void performTransformation(String transformationPath) {
        URI transformationURI = URI.createURI((String)transformationPath);
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        EList inObjects = this.sourceResource.getContents();
        BasicModelExtent input = new BasicModelExtent((List)inObjects);
        BasicModelExtent output = this.createNewModel ? new BasicModelExtent() : new BasicModelExtent((List)this.targetResource.getContents());
        ExecutionContextImpl context = new ExecutionContextImpl();
        if (this.selectedElement != null) {
            context.setConfigProperty(SELECTED_PLATFORM_PROPERTY, (Object)this.selectedElement);
            context.setConfigProperty(SELECTED_ANALYSISCONTEXT_PROPERTY, (Object)this.analysisContextQN);
        }
        OutputStreamWriter s = new OutputStreamWriter((OutputStream)CHESSProjectSupport.CHESS_CONSOLE);
        context.setLog((Log)new WriterLog((Writer)s));
        context.setProgressMonitor(this.monitor);
        Trace trace = Trace.createEmptyTrace();
        context.getSessionData().setValue((ISessionData.Entry)QVTEvaluationOptions.INCREMENTAL_UPDATE_TRACE, (Object)trace);
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{input, output});
        if (result.getSeverity() == 0) {
            List outObjects = output.getContents();
            this.targetResource.getContents().clear();
            this.targetResource.getContents().addAll((Collection)outObjects);
            try {
                this.targetResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            URI uri = this.targetResource.getURI();
            String tracePath = String.valueOf(uri.toString()) + ".qvtoTrace";
            URI traceURI = URI.createURI((String)tracePath);
            Resource traceResource = this.targetResource.getResourceSet().createResource(traceURI);
            traceResource.getContents().addAll((Collection)trace.getTraceContent());
            try {
                traceResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
            Activator.getDefault().getLog().log(status);
        }
    }

    protected boolean saveChessResource(final Resource chessResource, final List<EObject> outObjects) {
        try {
            TransactionalEditingDomain editingDomain = this.diagramEditPart.getEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    chessResource.getContents().clear();
                    chessResource.getContents().addAll((Collection)outObjects);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

