/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.mobius.model.SAN.SANModelPackage;
import org.polarsys.chess.mobius.transformations.QVToTransformation;

public class CHESS2SANRunner
implements IRunnableWithProgress {
    protected static final String SAN_MM_EXTENSION = "sanmodel";
    protected IContainer targetFolder;
    protected URI chessModelUri;
    protected Resource chessResource;
    private Resource sanResource;
    protected String rootComponentQualifiedName = "";
    protected DiagramEditPart diagramEditPart;
    protected String analysisContextQualifiedName = "";

    public IContainer getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(IContainer targetFolder) {
        this.targetFolder = targetFolder;
    }

    public URI getModelURI() {
        return this.chessModelUri;
    }

    public void setModelURI(URI modelURI) {
        this.chessModelUri = modelURI;
    }

    public void setAnalysisContextQualifiedName(String analysisContextQN) {
        this.analysisContextQualifiedName = analysisContextQN;
    }

    public void setRootComponent(String rootComponentQualifiedName) {
        this.rootComponentQualifiedName = rootComponentQualifiedName;
    }

    public Resource getChessResource() {
        return this.chessResource;
    }

    public void setChessResource(Resource chessResource) {
        this.chessResource = chessResource;
    }

    public void setDiagramEditPart(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.runInput2SANTransformation(monitor);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        CHESSProjectSupport.printlnToCHESSConsole((String)"*** CHESS to SAN transformation was performed successfully ***");
    }

    protected void runInput2SANTransformation(IProgressMonitor monitor) {
        SANModelPackage.eINSTANCE.getClass();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI flaMMuri = this.createFlaModelUri().appendFileExtension(SAN_MM_EXTENSION);
        new File(flaMMuri.path()).delete();
        this.setSANResource(resourceSet.createResource(flaMMuri));
        QVToTransformation transformation = new QVToTransformation();
        transformation.performCHESS2SANTransformation(this.chessResource, this.getSANResource(), monitor, this.rootComponentQualifiedName, this.analysisContextQualifiedName);
    }

    protected URI createFlaModelUri() {
        String modelName = this.getModelName();
        String flaPath = String.valueOf(this.targetFolder.getFullPath().toString()) + "/" + modelName;
        return URI.createPlatformResourceURI((String)flaPath, (boolean)false);
    }

    protected String getOutputXmlPath() {
        String modelName = this.getModelName();
        return this.targetFolder.getLocation().append(String.valueOf(modelName) + "_result.xml").toString();
    }

    protected String getModelName() {
        return this.chessModelUri.lastSegment().substring(0, this.chessModelUri.lastSegment().lastIndexOf(46));
    }

    protected void showErrorMessages(String title, List<String> messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(String.valueOf(message) + "\n");
        }
        this.showErrorMessage(title, sb.toString());
    }

    protected void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, title, 0);
    }

    public Resource getSANResource() {
        return this.sanResource;
    }

    public void setSANResource(Resource sanResource) {
        this.sanResource = sanResource;
    }
}

