/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.model.SAN.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.polarsys.chess.mobius.model.SAN.Activity;
import org.polarsys.chess.mobius.model.SAN.ActivityPlaceCase;
import org.polarsys.chess.mobius.model.SAN.AtomicNode;
import org.polarsys.chess.mobius.model.SAN.ComposedNode;
import org.polarsys.chess.mobius.model.SAN.Gate;
import org.polarsys.chess.mobius.model.SAN.GlobalVariable;
import org.polarsys.chess.mobius.model.SAN.GraphicalElement;
import org.polarsys.chess.mobius.model.SAN.InputGate;
import org.polarsys.chess.mobius.model.SAN.InstantaneousActivity;
import org.polarsys.chess.mobius.model.SAN.Join;
import org.polarsys.chess.mobius.model.SAN.NamedElement;
import org.polarsys.chess.mobius.model.SAN.Node;
import org.polarsys.chess.mobius.model.SAN.OutputGate;
import org.polarsys.chess.mobius.model.SAN.Place;
import org.polarsys.chess.mobius.model.SAN.Primitive;
import org.polarsys.chess.mobius.model.SAN.Rep;
import org.polarsys.chess.mobius.model.SAN.SANModel;
import org.polarsys.chess.mobius.model.SAN.SANModelPackage;
import org.polarsys.chess.mobius.model.SAN.SharedState;
import org.polarsys.chess.mobius.model.SAN.TimedActivity;

public class SANModelValidator
extends EObjectValidator {
    public static final SANModelValidator INSTANCE = new SANModelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.polarsys.chess.mobius.model.SAN";
    public static final int NAMED_ELEMENT__VALIDATE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return SANModelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSANModel((SANModel)value, diagnostics, context);
            }
            case 1: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 3: {
                return this.validateComposedNode((ComposedNode)value, diagnostics, context);
            }
            case 4: {
                return this.validateSharedState((SharedState)value, diagnostics, context);
            }
            case 5: {
                return this.validateJoin((Join)value, diagnostics, context);
            }
            case 6: {
                return this.validateRep((Rep)value, diagnostics, context);
            }
            case 7: {
                return this.validateAtomicNode((AtomicNode)value, diagnostics, context);
            }
            case 8: {
                return this.validatePlace((Place)value, diagnostics, context);
            }
            case 9: {
                return this.validateTimedActivity((TimedActivity)value, diagnostics, context);
            }
            case 10: {
                return this.validateInstantaneousActivity((InstantaneousActivity)value, diagnostics, context);
            }
            case 11: {
                return this.validateInputGate((InputGate)value, diagnostics, context);
            }
            case 12: {
                return this.validateOutputGate((OutputGate)value, diagnostics, context);
            }
            case 13: {
                return this.validateActivity((Activity)value, diagnostics, context);
            }
            case 14: {
                return this.validateGate((Gate)value, diagnostics, context);
            }
            case 15: {
                return this.validateGlobalVariable((GlobalVariable)value, diagnostics, context);
            }
            case 16: {
                return this.validateActivityPlaceCase((ActivityPlaceCase)value, diagnostics, context);
            }
            case 17: {
                return this.validateGraphicalElement((GraphicalElement)value, diagnostics, context);
            }
            case 18: {
                return this.validatePrimitive((Primitive)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSANModel(SANModel sanModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sanModel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sanModel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sanModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(sanModel, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(namedElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(namedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(namedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedElement_validate(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return namedElement.validate(diagnostics, context);
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(node, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateComposedNode(ComposedNode composedNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(composedNode, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(composedNode, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(composedNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(composedNode, diagnostics, context);
        }
        return result;
    }

    public boolean validateSharedState(SharedState sharedState, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sharedState, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sharedState, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sharedState, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(sharedState, diagnostics, context);
        }
        return result;
    }

    public boolean validateJoin(Join join, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(join, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(join, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(join, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(join, diagnostics, context);
        }
        return result;
    }

    public boolean validateRep(Rep rep, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rep, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rep, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(rep, diagnostics, context);
        }
        return result;
    }

    public boolean validateAtomicNode(AtomicNode atomicNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(atomicNode, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(atomicNode, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(atomicNode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(atomicNode, diagnostics, context);
        }
        return result;
    }

    public boolean validatePlace(Place place, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(place, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(place, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(place, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(place, diagnostics, context);
        }
        return result;
    }

    public boolean validateTimedActivity(TimedActivity timedActivity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(timedActivity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(timedActivity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(timedActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(timedActivity, diagnostics, context);
        }
        return result;
    }

    public boolean validateInstantaneousActivity(InstantaneousActivity instantaneousActivity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(instantaneousActivity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(instantaneousActivity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(instantaneousActivity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(instantaneousActivity, diagnostics, context);
        }
        return result;
    }

    public boolean validateInputGate(InputGate inputGate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(inputGate, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(inputGate, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(inputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(inputGate, diagnostics, context);
        }
        return result;
    }

    public boolean validateOutputGate(OutputGate outputGate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(outputGate, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(outputGate, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(outputGate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(outputGate, diagnostics, context);
        }
        return result;
    }

    public boolean validateActivity(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(activity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(activity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(activity, diagnostics, context);
        }
        return result;
    }

    public boolean validateGate(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gate, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gate, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(gate, diagnostics, context);
        }
        return result;
    }

    public boolean validateGlobalVariable(GlobalVariable globalVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(globalVariable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(globalVariable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(globalVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(globalVariable, diagnostics, context);
        }
        return result;
    }

    public boolean validateActivityPlaceCase(ActivityPlaceCase activityPlaceCase, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(activityPlaceCase, diagnostics, context);
    }

    public boolean validateGraphicalElement(GraphicalElement graphicalElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graphicalElement, diagnostics, context);
    }

    public boolean validatePrimitive(Primitive primitive, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(primitive, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(primitive, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(primitive, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_validate(primitive, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

