/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.transformations;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flaxml.FlaxmlPackage;
import org.polarsys.chess.fla.launch.Activator;

public class QVToTransformation {
    private static final String SELECTED_PLATFORM_PROPERTY = "selectedPlatformQName";
    private static final String CHESS2FLAMM = "platform:/plugin/org.polarsys.chess.fla.transformations/transforms/Chess2FlaMM.qvto";
    private static final String FLAMM2FLAXML = "platform:/plugin/org.polarsys.chess.fla.transformations/transforms/FlaMM2FlaXML.qvto";
    private static final String FLAXML2FLAMM = "platform:/plugin/org.polarsys.chess.fla.transformations/transforms/FlaXML2FlaMM.qvto";
    private static final String FLAMM2CHESS = "platform:/plugin/org.polarsys.chess.fla.transformations/transforms/FlaMM2Chess_BackPropagation.qvto";
    private static final String CHESS2FLAMMSPECIALIZATION = "platform:/plugin/org.polarsys.chess.fla.transformations/transforms/Chess2FLAMMSpecialization.qvto";
    boolean isChessUserAction;
    private DiagramEditPart diagramEditPart = null;
    private Resource sourceResource;
    private Resource targetResource;
    private boolean isTargetChessModel = false;
    private boolean createNewModel = true;
    private IProgressMonitor monitor;
    private String selectedElement = null;

    public void performChess2ConcertoFlaTransformation(Resource chessResource, Resource flaResource, IProgressMonitor monitor, String selectedElement) {
        FlammPackage.eINSTANCE.getClass();
        this.sourceResource = chessResource;
        this.targetResource = flaResource;
        this.monitor = monitor;
        this.selectedElement = selectedElement;
        this.performTransformation(CHESS2FLAMM);
    }

    public void performConcertoFla2ConcertoFlaXMLTransformation(Resource modelResource, Resource xmlResource, IProgressMonitor monitor) {
        FlaxmlPackage.eINSTANCE.getClass();
        this.sourceResource = modelResource;
        this.targetResource = xmlResource;
        this.monitor = monitor;
        this.performTransformation(FLAMM2FLAXML);
    }

    public void performConcertoFlaXml2ConcertoFlaTransformation(Resource xmlResource, Resource modelResource, IProgressMonitor monitor) {
        FlammPackage.eINSTANCE.getClass();
        FlaxmlPackage.eINSTANCE.getClass();
        this.sourceResource = xmlResource;
        this.targetResource = modelResource;
        this.monitor = monitor;
        this.performTransformation(FLAXML2FLAMM);
    }

    public void performConcertoFla2ChessBackPropagation(Resource flaResource, Resource chessResource, IProgressMonitor monitor, String selectedElement, DiagramEditPart diagramEditPart) {
        this.sourceResource = flaResource;
        this.targetResource = chessResource;
        this.monitor = monitor;
        this.selectedElement = selectedElement;
        this.diagramEditPart = diagramEditPart;
        this.isTargetChessModel = true;
        this.createNewModel = false;
        this.performTransformation(FLAMM2CHESS);
    }

    public void performChess2FlaMMSpecialization(Resource chessResource, Resource flaResource, IProgressMonitor monitor, String selectedElement) {
        this.sourceResource = chessResource;
        this.targetResource = flaResource;
        this.monitor = monitor;
        this.selectedElement = selectedElement;
        this.createNewModel = false;
        this.isTargetChessModel = false;
        System.out.println("I am here, where I could call the Transformation easily");
        this.performTransformation(CHESS2FLAMMSPECIALIZATION);
        System.out.println("I am done doing that");
    }

    private void performTransformation(String transformationPath) {
        URI transformationURI = URI.createURI((String)transformationPath);
        final TransformationExecutor executor = new TransformationExecutor(transformationURI);
        EList inObjects = this.sourceResource.getContents();
        BasicModelExtent input = new BasicModelExtent((List)inObjects);
        BasicModelExtent output = this.createNewModel ? new BasicModelExtent() : new BasicModelExtent((List)this.targetResource.getContents());
        final ExecutionContextImpl context = new ExecutionContextImpl();
        if (this.selectedElement != null) {
            context.setConfigProperty(SELECTED_PLATFORM_PROPERTY, (Object)this.selectedElement);
        }
        OutputStreamWriter s = new OutputStreamWriter((OutputStream)CHESSProjectSupport.CHESS_CONSOLE);
        context.setLog((Log)new WriterLog((Writer)s));
        context.setProgressMonitor(this.monitor);
        if (this.isTargetChessModel) {
            try {
                BasicModelExtent finalOutput = output;
                TransactionalEditingDomain editingDomain = this.diagramEditPart.getEditingDomain();
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, (ModelExtent)input, (ModelExtent)finalOutput){
                    private final /* synthetic */ ModelExtent val$input;
                    private final /* synthetic */ ModelExtent val$finalOutput;
                    {
                        this.val$input = modelExtent;
                        this.val$finalOutput = modelExtent2;
                        super($anonymous0);
                    }

                    protected void doExecute() {
                        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{this.val$input, this.val$finalOutput});
                        if (result.getSeverity() != 0) {
                            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
                            Activator.getDefault().getLog().log(status);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Everything is setup, lets execute it");
            ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{input, output});
            System.out.println("It has been executed");
            if (result.getSeverity() == 0) {
                List outObjects = output.getContents();
                this.targetResource.getContents().clear();
                this.targetResource.getContents().addAll((Collection)outObjects);
                try {
                    this.targetResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
                Activator.getDefault().getLog().log(status);
            }
        }
    }

    protected boolean saveChessResource(final Resource chessResource, final List<EObject> outObjects) {
        try {
            TransactionalEditingDomain editingDomain = this.diagramEditPart.getEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    chessResource.getContents().clear();
                    chessResource.getContents().addAll((Collection)outObjects);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

