/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cft.server.core.AbstractDebugProvider;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugProvider;
import org.eclipse.cft.server.core.internal.debug.NgrokDebugProvider;
import org.eclipse.cft.server.core.internal.debug.SshDebugProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class DebugProviderRegistry {
    private static final DebugProviderExtension[] providerExtensions = DebugProviderRegistry.getExtensionProviders();
    private static final AbstractDebugProvider[] defaultProviders = DebugProviderRegistry.getDefaultProviders();

    protected static AbstractDebugProvider getDebugProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        Object provider;
        Object[] objectArray = providerExtensions;
        int n = providerExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            provider = objectArray[n2];
            if (((DebugProviderExtension)provider).isDebugSupported(cloudServer, appModule)) {
                return ((DebugProviderExtension)provider).getInstance();
            }
            ++n2;
        }
        objectArray = defaultProviders;
        n = defaultProviders.length;
        n2 = 0;
        while (n2 < n) {
            provider = objectArray[n2];
            if (((AbstractDebugProvider)provider).isDebugSupported(appModule.getLocalModule(), cloudServer.getServer())) {
                return provider;
            }
            ++n2;
        }
        return null;
    }

    public static AbstractDebugProvider getProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        AbstractDebugProvider provider = DebugProviderRegistry.getDebugProvider(appModule, cloudServer);
        return provider;
    }

    public static AbstractDebugProvider getExistingProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        AbstractDebugProvider provider = DebugProviderRegistry.getProvider(appModule, cloudServer);
        if (provider == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)"Unable to find a debug provider for {0}. Please check if debug is supported for the given application in {1} ", (Object)appModule.getDeployedApplicationName(), (Object)cloudServer.getServer().getId()));
        }
        return provider;
    }

    private static AbstractDebugProvider[] getDefaultProviders() {
        return new CloudFoundryDebugProvider[]{new NgrokDebugProvider(), new SshDebugProvider()};
    }

    private static DebugProviderExtension[] getExtensionProviders() {
        IConfigurationElement[] configElements;
        ArrayList<DebugProviderExtension> providers = new ArrayList<DebugProviderExtension>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cft.server.core.debugProvider");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            providers.add(new DebugProviderExtension(elem));
            ++n2;
        }
        return providers.toArray(new DebugProviderExtension[providers.size()]);
    }

    private static class DebugProviderExtension {
        private static final String DEBUG_PROVIDER_SERVER_ID_ATTR = "serverTypeId";
        private static final String DEBUG_PROVIDER_CLASS_ATTR = "class";
        private static final String DEBUG_PROVIDER_MODULE_ELEM = "module";
        private static final String DEBUG_PROVIDER_TYPE_ATTR = "type";
        IConfigurationElement elem;
        String serverTypeId = null;
        Set<String> moduleTypes = null;
        AbstractDebugProvider instance = null;

        public DebugProviderExtension(IConfigurationElement elem) {
            this.elem = elem;
        }

        public boolean isDebugSupported(CloudFoundryServer cloudServer, CloudFoundryApplicationModule appModule) {
            String moduleType;
            String id = cloudServer.getServer().getServerType().getId();
            if (id != null && id.equals(this.getServerTypeId()) && (moduleType = appModule.getLocalModule().getModuleType().getId()) != null && this.getModuleTypes().contains(moduleType)) {
                return this.getInstance().isDebugSupported(appModule.getLocalModule(), cloudServer.getServer());
            }
            return false;
        }

        public AbstractDebugProvider getInstance() {
            if (this.instance == null) {
                try {
                    this.instance = (AbstractDebugProvider)this.elem.createExecutableExtension(DEBUG_PROVIDER_CLASS_ATTR);
                }
                catch (Exception e) {
                    CloudFoundryPlugin.logWarning(e.getMessage());
                }
            }
            return this.instance;
        }

        private String getServerTypeId() {
            if (this.serverTypeId == null) {
                this.serverTypeId = this.elem.getAttribute(DEBUG_PROVIDER_SERVER_ID_ATTR);
            }
            return this.serverTypeId;
        }

        private Set<String> getModuleTypes() {
            if (this.moduleTypes == null) {
                IConfigurationElement[] modules;
                this.moduleTypes = new HashSet<String>();
                IConfigurationElement[] iConfigurationElementArray = modules = this.elem.getChildren(DEBUG_PROVIDER_MODULE_ELEM);
                int n = modules.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement module = iConfigurationElementArray[n2];
                    String type = module.getAttribute(DEBUG_PROVIDER_TYPE_ATTR);
                    this.moduleTypes.add(type);
                    ++n2;
                }
            }
            return this.moduleTypes;
        }
    }
}

