/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.ICloudFoundryServiceWizardIconProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CloudFoundryServiceWizardIconProviderRegistry {
    private static final String ELEMENT = "serviceIconProvider";
    public static final String EXTENSION_POINT = "org.eclipse.cft.server.ui.serviceWizardIconProvider";
    private static CloudFoundryServiceWizardIconProviderRegistry instance = new CloudFoundryServiceWizardIconProviderRegistry();
    private Map<String, ICloudFoundryServiceWizardIconProvider> providers = new HashMap<String, ICloudFoundryServiceWizardIconProvider>();
    boolean isLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudFoundryServiceWizardIconProviderRegistry getInstance() {
        CloudFoundryServiceWizardIconProviderRegistry cloudFoundryServiceWizardIconProviderRegistry = instance;
        synchronized (cloudFoundryServiceWizardIconProviderRegistry) {
            if (!CloudFoundryServiceWizardIconProviderRegistry.instance.isLoaded) {
                instance.load();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloudFoundryServiceWizardIconProvider getIconProvider(String runtimeTypeId) {
        CloudFoundryServiceWizardIconProviderRegistry cloudFoundryServiceWizardIconProviderRegistry = this;
        synchronized (cloudFoundryServiceWizardIconProviderRegistry) {
            return this.providers.get(runtimeTypeId.toLowerCase());
        }
    }

    private void load() {
        this.isLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            CloudFoundryPlugin.logError((String)"Failed to load Cloud Foundry service icon extension providers from: org.eclipse.cft.server.ui.serviceWizardIconProvider");
        } else {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (ELEMENT.equals(config.getName())) {
                        try {
                            ICloudFoundryServiceWizardIconProvider provider = (ICloudFoundryServiceWizardIconProvider)config.createExecutableExtension("providerClass");
                            String runtimeTypeId = config.getAttribute("runtimeTypeId");
                            if (runtimeTypeId != null) {
                                this.providers.put(runtimeTypeId, provider);
                            } else {
                                CloudFoundryPlugin.logError((String)"Invalid server icon entry from:org.eclipse.cft.server.ui.serviceWizardIconProvider");
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

