/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.ColumnSortListener;
import org.eclipse.cft.server.ui.internal.IEventSource;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.TableResizeHelper;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CloudRoutePart
extends UIPart {
    public static IEventSource<?> ROUTES_REMOVED = new CloudUIEvent(Messages.CloudRoutePart_TEXT_ROUTES_REMOVED);
    private CheckboxTableViewer viewer;
    private Button showInUseButton;
    private Button showRemovedRoutesButton;
    private Button removeButton;
    private static final String IN_USE = "x";
    private List<CloudRoute> routesToRemove = new ArrayList<CloudRoute>();
    private List<CloudRoute> allRoutes = new ArrayList<CloudRoute>();
    private final Color DISABLED = Display.getDefault().getSystemColor(15);

    public TableViewer getViewer() {
        return this.viewer;
    }

    public List<CloudRoute> getRoutesToDelete() {
        return this.routesToRemove;
    }

    public void setInput(List<CloudRoute> routes) {
        if (routes == null || routes.isEmpty()) {
            this.notifyStatusChange(CloudFoundryPlugin.getErrorStatus((String)Messages.CloudRoutePart_ERROR_NO_ROUTE_AVAIL));
            return;
        }
        this.allRoutes = new ArrayList<CloudRoute>(routes);
        this.viewer.setInput(routes);
        this.refreshAll();
    }

    @Override
    public Control createPart(Composite parent) {
        Composite generalArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(generalArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)generalArea);
        this.createTableButtonArea(generalArea);
        this.createFilterButtons(generalArea);
        return generalArea;
    }

    protected void createFilterButtons(Composite parent) {
        this.showInUseButton = new Button(parent, 32);
        this.showInUseButton.setText(Messages.ROUTES_SHOW_IN_USE);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.showInUseButton);
        this.showInUseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudRoutePart.this.refreshAll();
            }
        });
        this.showRemovedRoutesButton = new Button(parent, 32);
        this.showRemovedRoutesButton.setText(Messages.ROUTES_SHOW_REMOVED);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.showRemovedRoutesButton);
        this.showRemovedRoutesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudRoutePart.this.refreshAll();
                String removeButtonLabel = CloudRoutePart.this.showRemovedRoutesButton.getSelection() ? Messages.CloudRoutePart_UNDO : Messages.COMMONTXT_REMOVE;
                CloudRoutePart.this.removeButton.setText(removeButtonLabel);
            }
        });
    }

    protected List<CloudRoute> getAllUnused() {
        ArrayList<CloudRoute> unused = new ArrayList<CloudRoute>();
        for (CloudRoute route : this.allRoutes) {
            if (route.inUse()) continue;
            unused.add(route);
        }
        return unused;
    }

    protected void createSelectionButtonArea(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttons);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttons);
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(Messages.SELECT_ALL);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudRoutePart.this.viewer.setCheckedElements((Object[])CloudRoutePart.this.getAllUnused().toArray(new CloudRoute[0]));
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(Messages.DESELECT_ALL);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)selectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudRoutePart.this.viewer.setCheckedElements((Object[])Collections.emptyList().toArray(new CloudRoute[0]));
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.COMMONTXT_REMOVE);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selectedRoutes = CloudRoutePart.this.viewer.getCheckedElements();
                if (selectedRoutes == null) {
                    selectedRoutes = new CloudRoute[]{};
                }
                ArrayList<CloudRoute> toRemove = new ArrayList<CloudRoute>(CloudRoutePart.this.routesToRemove);
                if (!CloudRoutePart.this.showRemovedRoutesButton.getSelection()) {
                    Object[] objectArray = selectedRoutes;
                    int n = selectedRoutes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!toRemove.contains(obj)) {
                            toRemove.add((CloudRoute)obj);
                        }
                        ++n2;
                    }
                } else {
                    Object[] objectArray = selectedRoutes;
                    int n = selectedRoutes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object obj = objectArray[n3];
                        toRemove.remove(obj);
                        ++n3;
                    }
                }
                CloudRoutePart.this.remove(toRemove);
            }
        });
    }

    protected void createTableButtonArea(Composite parent) {
        Composite buttonsAndViewer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonsAndViewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonsAndViewer);
        Composite tableArea = new Composite(buttonsAndViewer, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        this.createSelectionButtonArea(buttonsAndViewer);
        final Table table = new Table(tableArea, 2080);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new RoutesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider((TableViewer)this.viewer));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TableColumn sortColumn = table.getSortColumn();
                if (sortColumn != null) {
                    RouteColumn column = (RouteColumn)((Object)sortColumn.getData());
                    int result = 0;
                    int sortDirection = table.getSortDirection();
                    if (column != null && e1 instanceof CloudRoute && e2 instanceof CloudRoute) {
                        CloudRoute rt1 = (CloudRoute)e1;
                        CloudRoute rt2 = (CloudRoute)e2;
                        switch (column) {
                            case NAME: {
                                result = rt1.getName().toLowerCase().compareTo(rt2.getName().toLowerCase());
                                break;
                            }
                            case DOMAIN: {
                                result = rt1.getDomain().getName().compareTo(rt2.getDomain().getName());
                                break;
                            }
                            case IN_USE: {
                                if (rt1.inUse() && !rt2.inUse()) {
                                    result = -1;
                                    break;
                                }
                                if (!rt2.inUse() || rt1.inUse()) break;
                                result = 1;
                            }
                        }
                    }
                    return sortDirection == 128 ? result : -result;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object items, Object item) {
                if (item instanceof CloudRoute) {
                    CloudRoute route = (CloudRoute)item;
                    return route.inUse() ? CloudRoutePart.this.showInUseButton.getSelection() : CloudRoutePart.this.showRemovedRoutesButton.getSelection() && CloudRoutePart.this.routesToRemove.contains(route) || !CloudRoutePart.this.showRemovedRoutesButton.getSelection() && !CloudRoutePart.this.routesToRemove.contains(route);
                }
                return false;
            }
        });
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem tableItem;
                Object element;
                Widget item = event.item;
                if (event.detail == 32 && item instanceof TableItem && (element = (tableItem = (TableItem)item).getData()) instanceof CloudRoute && ((CloudRoute)element).inUse()) {
                    event.doit = false;
                    event.detail = 0;
                    tableItem.setChecked(false);
                }
            }
        });
        this.addColumns((TableViewer)this.viewer);
        new TableResizeHelper((TableViewer)this.viewer).enableResizing();
        this.viewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID >= 0) {
                    e.result = e.result != null ? NLS.bind((String)Messages.CloudRoutePart_TEXT_TABLE_ACC_LABEL, (Object)e.result) : Messages.CloudFoundryApplicationServicesWizardPage_TEXT_SERVICE_SELECTION;
                }
            }
        });
    }

    public void addColumns(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        int columnIndex = 0;
        ArrayList<String> columnProperties = new ArrayList<String>();
        TableColumn sortColumn = null;
        RouteColumn[] routeColumnArray = RouteColumn.values();
        int n = routeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            RouteColumn clm = routeColumnArray[n2];
            TableColumn tableColumn = new TableColumn(table, 0, columnIndex++);
            tableColumn.setText(clm.getName());
            tableColumn.setWidth(clm.getWidth());
            tableColumn.setData((Object)clm);
            columnProperties.add(clm.getName());
            tableColumn.addSelectionListener((SelectionListener)new ColumnSortListener(tableViewer){

                @Override
                protected void refresh() {
                    CloudRoutePart.this.refreshAll();
                }
            });
            if (sortColumn == null) {
                sortColumn = tableColumn;
            }
            ++n2;
        }
        if (sortColumn != null) {
            table.setSortColumn(sortColumn);
            table.setSortDirection(128);
        }
        tableViewer.setColumnProperties(columnProperties.toArray(new String[0]));
    }

    protected void remove(List<?> updatedToRemove) {
        if (this.routesToRemove.equals(updatedToRemove)) {
            return;
        }
        this.routesToRemove.clear();
        if (updatedToRemove != null) {
            for (Object obj : updatedToRemove) {
                CloudRoute route;
                if (!(obj instanceof CloudRoute) || this.routesToRemove.contains(route = (CloudRoute)obj)) continue;
                this.routesToRemove.add(route);
            }
        }
        this.notifyChange(new PartChangeEvent(this.routesToRemove, Status.OK_STATUS, ROUTES_REMOVED));
        this.refreshAll();
    }

    protected void refreshAll() {
        this.viewer.refresh(true);
        if (this.showInUseButton.getSelection()) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                CloudRoute route = (CloudRoute)item.getData();
                if (route.inUse()) {
                    item.setForeground(this.DISABLED);
                }
                ++n2;
            }
        }
    }

    protected static enum RouteColumn {
        NAME(Messages.COMMONTXT_NAME, 250),
        DOMAIN(Messages.CloudRoutePart_TEXT_ROUTE_DOMAIN, 100),
        IN_USE(Messages.CloudRoutePart_TEXT_ROUTE_INUSE, 30);

        private String name;
        private int width;

        private RouteColumn(String name, int width) {
            this.name = name;
            this.width = width;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }
    }

    protected class RoutesContentProvider
    implements IStructuredContentProvider {
        protected RoutesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray(new Object[0]);
            }
            return null;
        }
    }

    protected class TreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final TableViewer viewer;

        public TreeLabelProvider(TableViewer viewer) {
            this.viewer = viewer;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CloudRoute) {
                return ((CloudRoute)element).getName();
            }
            return super.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            TableColumn column = this.viewer.getTable().getColumn(columnIndex);
            if (column != null) {
                switch (columnIndex) {
                    case 0: {
                        result = this.getText(element);
                        break;
                    }
                    case 1: {
                        if (!(element instanceof CloudRoute)) break;
                        result = ((CloudRoute)element).getDomain().getName();
                        break;
                    }
                    case 2: {
                        if (!(element instanceof CloudRoute) || !((CloudRoute)element).inUse()) break;
                        return CloudRoutePart.IN_USE;
                    }
                }
            }
            return result;
        }
    }
}

