/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.rse.internal.ApplicationSubSystem;
import org.eclipse.cft.server.rse.internal.CloudFoundryConnectorService;
import org.eclipse.cft.server.rse.internal.CloudFoundryConnectorServiceManager;
import org.eclipse.cft.server.rse.internal.CloudFoundryFileAdapter;
import org.eclipse.cft.server.rse.internal.CloudFoundryFileService;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.cft.server.rse.internal.ICloudFoundryFileService;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public class ApplicationSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    private IHostFileToRemoteFileAdapter fileAdapter;

    public ApplicationSubSystemConfiguration() {
        this.setIsUnixStyle(true);
    }

    public IFileService createFileService(IHost host) {
        return new CloudFoundryFileService(host);
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost host, IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        return null;
    }

    public ISearchService createSearchService(IHost host) {
        return null;
    }

    public ISubSystem createSubSystemInternal(IHost conn) {
        CloudFoundryConnectorService connectorService = (CloudFoundryConnectorService)this.getConnectorService(conn);
        ApplicationSubSystem subsys = new ApplicationSubSystem(conn, (IConnectorService)connectorService, this.getFileService(conn), this.getHostFileAdapter(), this.getSearchService(conn));
        return subsys;
    }

    public IConnectorService getConnectorService(IHost conn) {
        return CloudFoundryConnectorServiceManager.getInstance().getConnectorService(conn, this.getServiceImplType());
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        if (this.fileAdapter == null) {
            this.fileAdapter = new CloudFoundryFileAdapter();
        }
        return this.fileAdapter;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem ss) {
        return null;
    }

    public Class getServiceImplType() {
        return ICloudFoundryFileService.class;
    }

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = FileServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        CloudFoundryConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public boolean supportsArchiveManagement() {
        return false;
    }

    public boolean supportsSubSystemConnect() {
        return false;
    }

    protected void addSubSystem(ISubSystem subsys) {
        super.addSubSystem(subsys);
        if (subsys instanceof ApplicationSubSystem) {
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)((ApplicationSubSystem)subsys));
            ServerEventHandler.getDefault().addServerListener((CloudServerListener)((ApplicationSubSystem)subsys));
        }
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            String poolName = ApplicationSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId());
            pool = mgr.createSystemFilterPool(poolName, false);
            if (pool != null) {
                RemoteFileFilterString accountsFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
                accountsFilterString.setPath(this.getSeparator());
                String[] filterStrings = new String[]{accountsFilterString.toString()};
                ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, "Accounts", filterStrings);
                filter.setNonDeletable(true);
                filter.setNonRenamable(true);
            }
        }
        catch (Exception e) {
            CloudFoundryRsePlugin.logError((String)"An error occurred creating default filter pool", (Throwable)e);
        }
        return pool;
    }

    protected void removeSubSystem(ISubSystem subsys) {
        if (subsys instanceof ApplicationSubSystem) {
            ServerCore.removeServerLifecycleListener((IServerLifecycleListener)((ApplicationSubSystem)subsys));
            ServerEventHandler.getDefault().removeServerListener((CloudServerListener)((ApplicationSubSystem)subsys));
        }
        super.removeSubSystem(subsys);
    }
}

