/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.cs;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentRule
extends org.polarsys.capella.core.transition.system.rules.cs.ComponentRule {
    protected void retrieveComponentGoDeep(EObject source, List<EObject> result, IContext context) {
        Component element = (Component)source;
        super.retrieveComponentGoDeep(source, result, context);
        result.addAll((Collection<EObject>)element.getRepresentingParts());
        result.addAll((Collection<EObject>)element.getFunctionalAllocations());
        result.addAll((Collection<EObject>)element.getUsedInterfaceLinks());
        result.addAll((Collection<EObject>)element.getImplementedInterfaceLinks());
        result.addAll((Collection<EObject>)element.getOwnedCommunicationLinks());
        IContextScopeHandler handler = ContextScopeHandlerHelper.getInstance((IContext)context);
        if (handler.contains("SOURCE_SCOPE", (EObject)element, context)) {
            String value = OptionsHandlerHelper.getInstance((IContext)context).getStringValue(context, "capella.core.transition.system2subsystem", "stateModesExport", "hierarchyReference");
            if ("onlyReference".equals(value)) {
                result.addAll((Collection<EObject>)element.getOwnedStateMachines());
                handler.addAll("SOURCE_SCOPE", (Collection)element.getOwnedStateMachines(), context);
            } else if ("hierarchyReference".equals(value)) {
                result.addAll((Collection<EObject>)element.getOwnedStateMachines());
                handler.addAll("SOURCE_SCOPE", (Collection)element.getOwnedStateMachines(), context);
                for (Component ancestor : this.getComponentAncestors(element)) {
                    result.addAll((Collection<EObject>)ancestor.getOwnedStateMachines());
                    handler.addAll("SOURCE_SCOPE", (Collection)ancestor.getOwnedStateMachines(), context);
                }
            }
            if (OptionsHandlerHelper.getInstance((IContext)context).getBooleanValue(context, "capella.core.transition.system2subsystem", "scenarioExport", false)) {
                result.addAll(EObjectExt.getReferencers((EObject)element, (EReference)InteractionPackage.Literals.INSTANCE_ROLE__REPRESENTED_INSTANCE));
            }
            handler.addAll("SOURCE_SCOPE", (Collection)element.getOwnedCommunicationLinks(), context);
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        if (container instanceof LogicalComponent) {
            return LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENTS;
        }
        if (container instanceof PhysicalComponent) {
            return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENTS;
        }
        if (container instanceof LogicalComponentPkg) {
            return LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS;
        }
        if (container instanceof PhysicalComponentPkg) {
            return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENTS;
        }
        return super.getTargetContainementFeature(element, result, container, context);
    }

    private Collection<Component> getComponentAncestors(Component component) {
        HashSet<Component> result = new HashSet<Component>();
        for (Part part : component.getRepresentingParts()) {
            for (Part componentAncestor : ComponentExt.getPartAncestors((Part)part)) {
                if (!(componentAncestor.getAbstractType() instanceof Component)) continue;
                result.add((Component)componentAncestor.getAbstractType());
            }
        }
        return result;
    }
}

