/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity;

import java.util.ArrayList;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.AbstractMorphNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IFeatureProvider;

public class MorphActivityFeature
extends AbstractMorphNodeFeature<Activity> {
    public MorphActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.MorphActivityFeature_Name;
    }

    public String getDescription() {
        return Messages.MorphActivityFeature_Description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_MORPH;
    }

    @Override
    public EClass getBusinessObjectClass() {
        return Bpmn2Package.eINSTANCE.getActivity();
    }

    @Override
    public void copyBusinessObject(Activity oldObject, Activity newObject) {
        newObject.setCompletionQuantity(oldObject.getCompletionQuantity());
        newObject.setDefault(oldObject.getDefault());
        if (newObject instanceof SubProcess) {
            newObject.setIoSpecification(null);
            newObject.getDataInputAssociations().clear();
            newObject.getDataOutputAssociations().clear();
        } else {
            InputOutputSpecification oldIoSpec = oldObject.getIoSpecification();
            ArrayList<DataInput> inputsToRemove = new ArrayList<DataInput>();
            ArrayList<DataOutput> outputsToRemove = new ArrayList<DataOutput>();
            if (oldIoSpec != null) {
                InputOutputSpecification newIoSpec = newObject.getIoSpecification();
                if (newIoSpec != null) {
                    String newName;
                    String oldName;
                    int j;
                    boolean addIt;
                    int i = 0;
                    while (i < oldIoSpec.getDataInputs().size()) {
                        DataInput odi = (DataInput)oldIoSpec.getDataInputs().get(i);
                        addIt = true;
                        j = 0;
                        while (j < newIoSpec.getDataInputs().size()) {
                            DataInput ndi = (DataInput)newIoSpec.getDataInputs().get(j);
                            oldName = new String(odi.getName());
                            if (oldName.equals(newName = new String(ndi.getName()))) {
                                inputsToRemove.add(odi);
                                addIt = false;
                                break;
                            }
                            ++j;
                        }
                        if (addIt) {
                            newIoSpec.getDataInputs().add(odi);
                        }
                        ++i;
                    }
                    oldIoSpec.getDataInputs().removeAll(inputsToRemove);
                    i = 0;
                    while (i < oldIoSpec.getDataOutputs().size()) {
                        DataOutput odo = (DataOutput)oldIoSpec.getDataOutputs().get(i);
                        addIt = true;
                        j = 0;
                        while (j < newIoSpec.getDataOutputs().size()) {
                            DataOutput ndo = (DataOutput)newIoSpec.getDataOutputs().get(j);
                            oldName = new String(odo.getName());
                            if (oldName.equals(newName = new String(ndo.getName()))) {
                                outputsToRemove.add(odo);
                                addIt = false;
                                break;
                            }
                            ++j;
                        }
                        if (addIt) {
                            newIoSpec.getDataOutputs().add(odo);
                        }
                        ++i;
                    }
                    oldIoSpec.getDataOutputs().removeAll(outputsToRemove);
                    if (oldIoSpec.getInputSets().size() > 0) {
                        i = 0;
                        while (i < oldIoSpec.getInputSets().size()) {
                            InputSet ois = (InputSet)oldIoSpec.getInputSets().get(i);
                            ois.getDataInputRefs().removeAll(inputsToRemove);
                            if (ois.getDataInputRefs().size() > 0) {
                                InputSet nis = null;
                                if (newIoSpec.getInputSets().size() > i) {
                                    nis = (InputSet)newIoSpec.getInputSets().get(i);
                                    nis.getDataInputRefs().addAll(ois.getDataInputRefs());
                                } else {
                                    newIoSpec.getInputSets().add(ois);
                                }
                            }
                            ++i;
                        }
                    }
                    if (oldIoSpec.getOutputSets().size() > 0) {
                        i = 0;
                        while (i < oldIoSpec.getOutputSets().size()) {
                            OutputSet oos = (OutputSet)oldIoSpec.getOutputSets().get(i);
                            oos.getDataOutputRefs().removeAll(outputsToRemove);
                            if (oos.getDataOutputRefs().size() > 0) {
                                OutputSet nos = null;
                                if (newIoSpec.getOutputSets().size() > i) {
                                    nos = (OutputSet)newIoSpec.getOutputSets().get(i);
                                    nos.getDataOutputRefs().addAll(oos.getDataOutputRefs());
                                } else {
                                    newIoSpec.getOutputSets().add(oos);
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    newObject.setIoSpecification(oldIoSpec);
                }
            }
            ArrayList inputAssociations = new ArrayList();
            inputAssociations.addAll(oldObject.getDataInputAssociations());
            for (DataInputAssociation dia : inputAssociations) {
                if (inputsToRemove.contains(dia.getTargetRef())) continue;
                newObject.getDataInputAssociations().add(dia);
            }
            ArrayList outputAssociations = new ArrayList();
            outputAssociations.addAll(oldObject.getDataOutputAssociations());
            for (DataOutputAssociation doa : outputAssociations) {
                boolean addIt = true;
                for (ItemAwareElement e : doa.getSourceRef()) {
                    if (!outputsToRemove.contains(e)) continue;
                    addIt = false;
                    break;
                }
                if (!addIt) continue;
                newObject.getDataOutputAssociations().add(doa);
            }
        }
        newObject.setIsForCompensation(oldObject.isIsForCompensation());
        String defaultName = ModelUtil.toCanonicalString((String)oldObject.getId());
        if (!defaultName.equals(oldObject.getName())) {
            newObject.setName(oldObject.getName());
        }
        newObject.setStartQuantity(oldObject.getStartQuantity());
        newObject.getBoundaryEventRefs().addAll(oldObject.getBoundaryEventRefs());
        for (Property p : oldObject.getProperties()) {
            if (newObject.getProperties().contains(p)) continue;
            newObject.getProperties().add(p);
        }
        for (ResourceRole rr : oldObject.getResources()) {
            if (newObject.getResources().contains(rr)) continue;
            newObject.getResources().add(rr);
        }
    }
}

