/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.wizards.PsfStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class PsfFilenameStore
extends PsfStore {
    private static final String FILENAMES = "filenames";
    private static final String PREVIOUS = "previous";
    private String _selectedFilename = null;
    private static PsfFilenameStore instance;

    public static PsfFilenameStore getInstance() {
        if (instance == null) {
            instance = new PsfFilenameStore();
        }
        return instance;
    }

    private PsfFilenameStore() {
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultFromSelection(IWorkbench workbench) {
        void selection;
        IWorkbenchWindow wnd = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)sel;
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return;
        }
        IResource resource = (IResource)o;
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.isAccessible()) {
            return;
        }
        String extension = resource.getFileExtension();
        if (extension == null || !extension.equalsIgnoreCase("psf")) {
            return;
        }
        IWorkspace workspace = resource.getWorkspace();
        workspace.getRoot().getFullPath();
        IPath path = resource.getLocation();
        this._selectedFilename = path.toOSString();
    }

    @Override
    public String getSuggestedDefault() {
        if (this._selectedFilename != null) {
            return this._selectedFilename;
        }
        return this.getPrevious();
    }

    @Override
    protected String getPreviousTag() {
        return PREVIOUS;
    }

    @Override
    protected String getListTag() {
        return FILENAMES;
    }
}

