/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.util.Attributes;
import org.osgi.framework.Bundle;

public class BundleMetadata {
    public static final String BUNDLE = "org.eclipse.jetty.osgi.bundle";
    private final Bundle bundle;
    private final Path bundlePath;
    private final String contextPath;
    private final Attributes attributes = new Attributes.Mapped();
    private final String pathToResourceBase;

    public BundleMetadata(Bundle bundle) throws Exception {
        this(bundle, null);
    }

    public BundleMetadata(Bundle bundle, String pathToResourceBase) throws Exception {
        this.bundle = bundle;
        this.bundlePath = Util.getBundlePath(bundle);
        this.contextPath = Util.getContextPath(bundle);
        this.pathToResourceBase = pathToResourceBase;
        Dictionary headers = bundle.getHeaders();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = (String)headers.get(key);
            if ("jetty.deploy.defaultsDescriptor".equalsIgnoreCase(key) || "Jetty-defaultWebXmlFilePath".equalsIgnoreCase(key)) {
                this.getAttributes().setAttribute("jetty.deploy.defaultsDescriptor", (Object)val);
                continue;
            }
            if ("Jetty-WebXmlFilePath".equalsIgnoreCase(key)) {
                this.getAttributes().setAttribute(key, (Object)val);
                continue;
            }
            if (!"Jetty-ContextFilePath".equalsIgnoreCase(key)) continue;
            this.getAttributes().setAttribute(key, (Object)val);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Path getPath() {
        return this.bundlePath;
    }

    public String getPathToResourceBase() {
        return this.pathToResourceBase;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }
}

