/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.deploy.StandardDeployer;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.BundleContextProvider;
import org.eclipse.jetty.osgi.BundleWebAppProvider;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.PackageAdminServiceListener;
import org.eclipse.jetty.osgi.ServerClasspathContributor;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.util.FakeURLClassLoader;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEEActivator
implements BundleActivator,
ServerClasspathContributor.Registry {
    private BundleContext _bootBundleContext;
    private ServiceTracker<Server, Object> _serverTracker;
    private PackageAdminServiceListener _packageAdminServiceListener;
    private final Collection<ServerClasspathContributor> _serverClasspathContributors = new ArrayList<ServerClasspathContributor>();

    public void start(BundleContext context) throws Exception {
        this._bootBundleContext = context;
        this._packageAdminServiceListener = new PackageAdminServiceListener(this, this._bootBundleContext);
        this._serverTracker = new ServiceTracker(context, context.createFilter("(objectclass=" + Server.class.getName() + ")"), (ServiceTrackerCustomizer)new ServerTracker(this._bootBundleContext.getBundle()));
        this._serverTracker.open();
        ResourceFactory.registerResourceFactory((String)"bundleresource", (ResourceFactory)new URLResourceFactory());
    }

    public BundleContext getBootBundleContext() {
        return this._bootBundleContext;
    }

    @Override
    public void registerServerClasspathContributor(ServerClasspathContributor contributor) {
        this._serverClasspathContributors.add(contributor);
    }

    @Override
    public void unregisterServerClasspathContributor(ServerClasspathContributor contributor) {
        this._serverClasspathContributors.remove(contributor);
    }

    public Collection<ServerClasspathContributor> getServerClasspathContributors() {
        return this._serverClasspathContributors;
    }

    public void stop(BundleContext context) throws Exception {
        if (this._serverTracker != null) {
            this._serverTracker.close();
            this._serverTracker = null;
        }
        if (this._packageAdminServiceListener != null) {
            this._packageAdminServiceListener.stop();
            this._packageAdminServiceListener = null;
        }
    }

    public abstract String getEnvironment();

    public abstract ContextFactory newContextFactory(Bundle var1);

    public abstract ContextFactory newWebAppFactory(Bundle var1);

    public abstract String getMetaInfContainerBundlePatternAttributeName();

    public class ServerTracker
    implements ServiceTrackerCustomizer<Server, Object> {
        private static final Logger LOG = LoggerFactory.getLogger(ServerTracker.class);
        private Bundle _myBundle = null;

        public ServerTracker(Bundle bundle) {
            this._myBundle = bundle;
        }

        public Object addingService(ServiceReference<Server> sr) {
            Bundle contributor = sr.getBundle();
            Server server = (Server)contributor.getBundleContext().getService(sr);
            ArrayList contributedURLs = new ArrayList();
            ArrayList contributedBundles = new ArrayList();
            Collection<ServerClasspathContributor> serverClasspathContributors = AbstractEEActivator.this.getServerClasspathContributors();
            serverClasspathContributors.forEach(c -> contributedBundles.addAll(c.getScannableBundles()));
            contributedBundles.forEach(b -> contributedURLs.addAll(this.convertBundleToURL((Bundle)b)));
            if (!contributedURLs.isEmpty()) {
                ClassLoader serverClassLoader = (ClassLoader)server.getAttribute("org.eclipse.jetty.osgi.server.classLoader");
                if (serverClassLoader != null) {
                    server.setAttribute("org.eclipse.jetty.osgi.server.classLoader", (Object)new FakeURLClassLoader(serverClassLoader, contributedURLs.toArray(new URL[0])));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Server classloader for contexts = {}", server.getAttribute("org.eclipse.jetty.osgi.server.classLoader"));
                    }
                }
                server.setAttribute("org.eclipse.jetty.osgi.server.classpathBundles", contributedBundles);
            }
            Optional<StandardDeployer> serverDeployer = this.getDeployer(server);
            AbstractContextProvider webAppProvider = null;
            AbstractContextProvider contextProvider = null;
            String containerScanBundlePattern = null;
            if (!contributedBundles.isEmpty()) {
                containerScanBundlePattern = contributedBundles.stream().map(Bundle::getSymbolicName).collect(Collectors.joining("|"));
            }
            if (serverDeployer.isPresent()) {
                StandardDeployer deployer = serverDeployer.get();
                Collection osgiProviders = deployer.getBeans(AbstractContextProvider.class);
                for (AbstractContextProvider provider : osgiProviders) {
                    BundleWebAppProvider bundleWebAppProvider;
                    BundleContextProvider bundleContextProvider;
                    if (provider instanceof BundleContextProvider && (bundleContextProvider = (BundleContextProvider)provider).getEnvironmentName().equalsIgnoreCase(AbstractEEActivator.this.getEnvironment())) {
                        contextProvider = bundleContextProvider;
                    }
                    if (!(provider instanceof BundleWebAppProvider) || !(bundleWebAppProvider = (BundleWebAppProvider)provider).getEnvironmentName().equalsIgnoreCase(AbstractEEActivator.this.getEnvironment())) continue;
                    webAppProvider = bundleWebAppProvider;
                }
                if (contextProvider == null) {
                    contextProvider = new BundleContextProvider(server, (Deployer)deployer, AbstractEEActivator.this.getEnvironment(), AbstractEEActivator.this.newContextFactory(this._myBundle));
                    deployer.addBean((Object)contextProvider);
                }
                if (webAppProvider == null) {
                    webAppProvider = new BundleWebAppProvider(server, (Deployer)deployer, AbstractEEActivator.this.getEnvironment(), AbstractEEActivator.this.newWebAppFactory(this._myBundle));
                    deployer.addBean((Object)webAppProvider);
                }
                if (containerScanBundlePattern != null) {
                    contextProvider.getAttributes().setAttribute(AbstractEEActivator.this.getMetaInfContainerBundlePatternAttributeName(), (Object)containerScanBundlePattern);
                    webAppProvider.getAttributes().setAttribute(AbstractEEActivator.this.getMetaInfContainerBundlePatternAttributeName(), (Object)containerScanBundlePattern);
                }
            } else {
                LOG.info("No DeploymentManager for Server {}", (Object)server);
            }
            try {
                if (!server.isStarted()) {
                    server.start();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to start server {}", (Object)server);
            }
            return server;
        }

        public void modifiedService(ServiceReference<Server> reference, Object service) {
            this.removedService(reference, service);
            this.addingService(reference);
        }

        public void removedService(ServiceReference<Server> reference, Object service) {
        }

        private Optional<StandardDeployer> getDeployer(Server server) {
            Collection deployers = server.getBeans(StandardDeployer.class);
            return deployers.stream().findFirst();
        }

        private List<URL> convertBundleToURL(Bundle bundle) {
            ArrayList<URI> uris = new ArrayList<URI>();
            try {
                Path location = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle).toPath();
                if (Files.isDirectory(location, new LinkOption[0])) {
                    for (Path path : this.listing(location)) {
                        Path filename;
                        if (FileID.isJavaArchive((Path)path)) {
                            uris.add(path.toUri());
                            continue;
                        }
                        if (!Files.isDirectory(path, new LinkOption[0]) || (filename = path.getFileName()) == null || !filename.toString().equalsIgnoreCase("lib")) continue;
                        for (Path lib : this.listing(path)) {
                            if (!FileID.isJavaArchive((Path)lib)) continue;
                            uris.add(lib.toUri());
                        }
                    }
                } else {
                    uris.add(location.toUri());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to convert bundle {} to url", (Object)bundle, (Object)e);
            }
            ArrayList<URL> list = new ArrayList<URL>();
            try {
                for (URI uri : uris) {
                    URI correctURI = URIUtil.correctURI((URI)uri);
                    URL url = correctURI.toURL();
                    list.add(url);
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to convert bundle {} to url", (Object)bundle, (Object)e);
            }
            return list;
        }

        private List<Path> listing(Path dir) throws IOException {
            try (Stream<Path> listing = Files.list(dir);){
                List<Path> list = listing.toList();
                return list;
            }
        }
    }
}

