/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.GraphControl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RDBTableDropListener
extends DropTargetAdapter {
    protected Viewer viewer;
    protected SQLDomainModel domainModel;

    public RDBTableDropListener(Viewer viewer, SQLDomainModel domainModel) {
        this.viewer = viewer;
        this.domainModel = domainModel;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private boolean okToAddView(ViewTable view) {
        QueryExpression expr;
        QueryStatement oQuery;
        return view == null || !((oQuery = this.domainModel.getSQLStatement()) instanceof QuerySelectStatement) || !((expr = view.getQueryExpression()) instanceof QueryExpressionRoot) || oQuery != ((QueryExpressionRoot)expr).getSelectStatement();
    }

    public void drop(DropTargetEvent event) {
        SQLQueryObject currentStatement;
        if (event.data == null) {
            event.detail = 0;
            return;
        }
        Table[] tables = this.getTables(event);
        if (tables != null && (currentStatement = this.getCurrentStatement()) != null) {
            String tableName;
            String tableSchema;
            int i;
            boolean parentView;
            QuerySelectStatement select;
            String dbName = null;
            Database db = this.domainModel.getDatabase();
            if (db != null) {
                dbName = db.getName();
            }
            if (currentStatement instanceof QuerySelectStatement) {
                select = (QuerySelectStatement)currentStatement;
                parentView = false;
                i = 0;
                while (i < tables.length) {
                    if (tables[i].getSchema().getDatabase().getName().equals(dbName)) {
                        EList tableRefList;
                        List tableExprList;
                        TableExpression tableExpr;
                        QueryExpressionBody body;
                        if (tables[i] instanceof ViewTable && !this.okToAddView((ViewTable)tables[i])) {
                            parentView = true;
                        }
                        tableSchema = tables[i].getSchema().getName();
                        tableName = tables[i].getName();
                        QueryExpressionRoot root = select.getQueryExpr();
                        if (root != null && (body = root.getQuery()) instanceof QuerySelect && (tableExpr = TableHelper.findTableExpressionInTableExpressionList((String)tableSchema, (String)tableName, (List)(tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)(tableRefList = ((QuerySelect)body).getFromClause()))))) == null && !parentView) {
                            tableExpr = TableHelper.createTableExpressionForTable((Table)tables[i]);
                            SelectHelper.addTableToStatement(select, tableExpr);
                        }
                    }
                    ++i;
                }
            }
            if (currentStatement instanceof QuerySelect) {
                select = (QuerySelect)currentStatement;
                parentView = false;
                i = 0;
                while (i < tables.length) {
                    if (tables[i].getSchema().getDatabase().getName().equals(dbName)) {
                        EList tableRefList;
                        List tableExprList;
                        TableExpression tableExpr;
                        if (tables[i] instanceof ViewTable && !this.okToAddView((ViewTable)tables[i])) {
                            parentView = true;
                        }
                        if ((tableExpr = TableHelper.findTableExpressionInTableExpressionList((String)(tableSchema = tables[i].getSchema().getName()), (String)(tableName = tables[i].getName()), (List)(tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)(tableRefList = select.getFromClause()))))) == null && !parentView) {
                            tableExpr = TableHelper.createTableExpressionForTable((Table)tables[i]);
                            SelectHelper.addTableToStatement((QuerySelect)select, tableExpr);
                        }
                    }
                    ++i;
                }
            } else if (tables[0].getSchema().getDatabase().getName().equals(dbName)) {
                if (currentStatement instanceof QueryInsertStatement) {
                    QueryInsertStatement insert = (QueryInsertStatement)currentStatement;
                    TableInDatabase rdbTable = TableHelper.createTableExpressionForTable((Table)tables[0]);
                    insert.setTargetTable(rdbTable);
                } else if (currentStatement instanceof QueryUpdateStatement) {
                    QueryUpdateStatement update = (QueryUpdateStatement)currentStatement;
                    TableInDatabase rdbTable = TableHelper.createTableExpressionForTable((Table)tables[0]);
                    update.setTargetTable(rdbTable);
                } else if (currentStatement instanceof QueryDeleteStatement) {
                    QueryDeleteStatement delete = (QueryDeleteStatement)currentStatement;
                    TableInDatabase rdbTable = TableHelper.createTableExpressionForTable((Table)tables[0]);
                    delete.setTargetTable(rdbTable);
                }
            }
            boolean hasWorngTable = false;
            int i2 = 0;
            while (i2 < tables.length) {
                if (!tables[i2].getSchema().getDatabase().equals(db)) {
                    hasWorngTable = true;
                    break;
                }
                ++i2;
            }
            if (hasWorngTable) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages._UI_DIALOG_WARNING_TITLE, (String)Messages._UI_INVALID_TABLE_ADDED);
            }
        }
        if (this.viewer instanceof GraphControl) {
            ((GraphControl)this.viewer).updateForDND();
        }
        event.detail = 0;
    }

    protected SQLQueryObject getCurrentStatement() {
        Object obj = this.viewer.getInput();
        if (obj instanceof QueryStatement || obj instanceof QuerySelect) {
            return (SQLQueryObject)obj;
        }
        return null;
    }

    protected Table[] getTables(DropTargetEvent event) {
        Object obj = event.data;
        if (obj instanceof StructuredSelection) {
            Object[] selections = ((StructuredSelection)obj).toArray();
            Table[] tables = new Table[selections.length];
            int i = 0;
            while (i < selections.length) {
                if (!(selections[i] instanceof Table)) {
                    return null;
                }
                tables[i] = (Table)selections[i];
                ++i;
            }
            return tables;
        }
        if (event.data instanceof IResource[]) {
            IResource[] resources = (IResource[])event.data;
            ArrayList tables = new ArrayList();
            int i = 0;
            while (i < resources.length) {
                IFile file;
                String extension;
                IResource resource = resources[i];
                if (resource instanceof IFile && (extension = (file = (IFile)resource).getFileExtension()).equalsIgnoreCase("TBLXMI")) {
                    this.domainModel.getIFile().getParent().equals((Object)file.getParent());
                }
                ++i;
            }
            Table[] result = new Table[tables.size()];
            return tables.toArray(result);
        }
        return null;
    }
}

