/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.PreferenceUtil;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class ResultHistoryHelper {
    public static final int COLUMN_NUMBER = 7;
    public static final int STATUS_INDEX = 0;
    public static final int OPER_INDEX = 1;
    public static final int FREQ_INDEX = 2;
    public static final int DATE_INDEX = 3;
    public static final int ACTION_INDEX = 4;
    public static final int CONSUMER_INDEX = 5;
    public static final int PROFILE_INDEX = 6;
    public static final Map COLUMN_PREFERENCE_INDEX_MAP = new HashMap();
    public static final Map COLUMN_PREFERENCE_ORDER_MAP = new HashMap();
    public static final Map COLUMN_NAME_PREFERENCE_MAP = new HashMap();
    public static String[] COLUMN_PREFERENCE = new String[]{PreferenceConstants.RESULT_HISTORY_STATUS_COLUMN, PreferenceConstants.RESULT_HISTORY_OPER_COLUMN, PreferenceConstants.RESULT_HISTORY_FREQ_COLUMN, PreferenceConstants.RESULT_HISTORY_DATE_COLUMN, PreferenceConstants.RESULT_HISTORY_ACTION_COLUMN, PreferenceConstants.RESULT_HISTORY_CONSUMER_COLUMN, PreferenceConstants.RESULT_HISTORY_PROFILE_COLUMN};
    public static String[] COLUMN_NAME = new String[]{Messages.ResultHistorySection_status, Messages.ResultHistorySection_operation, Messages.ResultHistorySection_frequency, Messages.ResultHistorySection_date, Messages.ResultHistorySection_action_type, Messages.ResultHistorySection_consumer_name, Messages.ResultHistorySection_connection_profile};

    static {
        int i = 0;
        while (i < COLUMN_PREFERENCE.length) {
            COLUMN_PREFERENCE_INDEX_MAP.put(COLUMN_PREFERENCE[i], i);
            ++i;
        }
        i = 0;
        while (i < COLUMN_NAME.length) {
            COLUMN_NAME_PREFERENCE_MAP.put(COLUMN_NAME[i], COLUMN_PREFERENCE[i]);
            ++i;
        }
    }

    public static void refreshOrderFromPreference(boolean usePreference) {
        COLUMN_PREFERENCE_ORDER_MAP.clear();
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < COLUMN_PREFERENCE.length) {
            int order = PreferenceUtil.getInt(store, COLUMN_PREFERENCE[i], usePreference);
            COLUMN_PREFERENCE_ORDER_MAP.put(COLUMN_PREFERENCE[i], order);
            ++i;
        }
    }

    public static int getConfigurableColumnIndex(int order, boolean usePreference) {
        if (order < 0 || order > 6) {
            return -1;
        }
        ResultHistoryHelper.refreshOrderFromPreference(usePreference);
        String preferenceString = null;
        for (Object obj : COLUMN_PREFERENCE_ORDER_MAP.keySet()) {
            if ((Integer)COLUMN_PREFERENCE_ORDER_MAP.get(obj) != order) continue;
            preferenceString = (String)obj;
            break;
        }
        if (preferenceString != null) {
            return (Integer)COLUMN_PREFERENCE_INDEX_MAP.get(preferenceString);
        }
        return -1;
    }

    public static int getConfigurableColumnIndex(String columnName) {
        ResultHistoryHelper.refreshOrderFromPreference(true);
        Object obj = COLUMN_NAME_PREFERENCE_MAP.get(columnName);
        if (obj != null && COLUMN_PREFERENCE_ORDER_MAP.get(obj) != null) {
            return (Integer)COLUMN_PREFERENCE_ORDER_MAP.get(obj);
        }
        return -1;
    }

    public static int getColumnNumber(boolean usePreference) {
        ResultHistoryHelper.refreshOrderFromPreference(usePreference);
        int count = 0;
        for (Object preference : COLUMN_PREFERENCE_ORDER_MAP.keySet()) {
            if ((Integer)COLUMN_PREFERENCE_ORDER_MAP.get(preference) < 0) continue;
            ++count;
        }
        return count;
    }
}

