/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.debug;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.debugger.breakpoint.ISPBreakpoint;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.SQLDebuggerConfiguration;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.ui.DebuggerImages;
import org.eclipse.datatools.sqltools.debugger.debug.Messages;
import org.eclipse.datatools.sqltools.debugger.model.SPStackFrame;
import org.eclipse.datatools.sqltools.debugger.model.SPVariable;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class SPModelPresentation
implements IDebugModelPresentation {
    Map _attributes = new HashMap();

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this._attributes.put(attribute, value);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String result = "";
        try {
            result = value.getValueString();
        }
        catch (DebugException e) {
            DebuggerCorePlugin.getDefault().log((Throwable)e);
        }
        listener.detailComputed(value, result);
    }

    public IEditorInput getEditorInput(Object item) {
        try {
            if (item instanceof IMarker) {
                item = this.getBreakpoint((IMarker)item);
            }
            if (item instanceof ISPBreakpoint) {
                item = ((ISPBreakpoint)item).getProcIdentifier();
            }
            if (item instanceof ProcIdentifier) {
                return this.getEditorInput((ProcIdentifier)item);
            }
            return null;
        }
        catch (CoreException e) {
            DebuggerCorePlugin.getDefault().log(Messages.SPModelPresentation_errorGetEditorInput, (Throwable)e);
            return null;
        }
    }

    protected IEditorInput getEditorInput(ProcIdentifier procid) throws CoreException {
        SQLDebuggerConfiguration sqlDebugConf;
        IDebugModelPresentation debugModelPresentation;
        if (procid == null) {
            return null;
        }
        SQLDevToolsConfiguration sqlDTC = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)procid.getDatabaseIdentifier());
        DBHelper helper = sqlDTC.getDBHelper();
        if (helper != null && helper.isAdHocProc(procid)) {
            return null;
        }
        if (sqlDTC instanceof SQLDebuggerConfiguration && (debugModelPresentation = (sqlDebugConf = (SQLDebuggerConfiguration)sqlDTC).getDebugModelPresentation()) != null) {
            return debugModelPresentation.getEditorInput((Object)procid);
        }
        return new ProcEditorInput(procid);
    }

    public String getEditorId(IEditorInput input, Object element) {
        try {
            SQLDebuggerConfiguration sqlDebugConf;
            IDebugModelPresentation debugModelPresentation;
            ProcIdentifier procid;
            SQLDevToolsConfiguration sqlDTC;
            if (element instanceof IMarker) {
                element = this.getBreakpoint((IMarker)element);
            }
            if (element instanceof ISPBreakpoint) {
                element = ((ISPBreakpoint)element).getProcIdentifier();
            }
            if (element instanceof ProcIdentifier && (sqlDTC = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)(procid = (ProcIdentifier)element).getDatabaseIdentifier())) != null && sqlDTC instanceof SQLDebuggerConfiguration && (debugModelPresentation = (sqlDebugConf = (SQLDebuggerConfiguration)sqlDTC).getDebugModelPresentation()) != null) {
                return debugModelPresentation.getEditorId(input, element);
            }
        }
        catch (CoreException e) {
            DebuggerCorePlugin.getDefault().log(Messages.SPModelPresentation_errorGetEditorInput, (Throwable)e);
            return null;
        }
        if (input instanceof ProcEditorInput) {
            return "org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor";
        }
        return "org.eclipse.datatools.sqltools.sqleditor.SQLEditor";
    }

    public String getText(Object item) {
        block17: {
            try {
                if (item instanceof IVariable) {
                    return this.getVariableText((IVariable)item);
                }
                if (item instanceof IStackFrame) {
                    return this.getStackFrameText((IStackFrame)item);
                }
                if (!(item instanceof IMarker)) break block17;
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)item);
                if (breakpoint != null) {
                    return this.getBreakpointText(breakpoint);
                }
                return null;
            }
            catch (CoreException coreException) {
                return Messages.SPModelPresentation_notRespondingFlag;
            }
        }
        if (item instanceof IBreakpoint) {
            return this.getBreakpointText((IBreakpoint)item);
        }
        if (item instanceof IWatchExpression) {
            return this.getWatchExpressionText((IWatchExpression)item);
        }
        if (item instanceof IExpression) {
            return this.getExpressionText((IExpression)item);
        }
        StringBuffer label = new StringBuffer();
        if (item instanceof IThread) {
            label.append(this.getThreadText((IThread)item));
        } else if (item instanceof IDebugTarget) {
            label.append(this.getDebugTargetText((IDebugTarget)item));
        } else if (item instanceof IValue) {
            label.append(this.getValueText((IValue)item));
        }
        if (item instanceof ITerminate && ((ITerminate)item).isTerminated()) {
            label.insert(0, Messages.SPModelPresentation_terminatedFlag);
            return label.toString();
        }
        if (item instanceof IDisconnect && ((IDisconnect)item).isDisconnected()) {
            label.insert(0, Messages.SPModelPresentation_disconnectedFlag);
            return label.toString();
        }
        if (label.length() > 0) {
            return label.toString();
        }
        return null;
    }

    private String getDebugTargetText(IDebugTarget target) throws CoreException {
        return Messages.SPModelPresentation_debugTarget;
    }

    private String getValueText(IValue value) {
        try {
            return value.getValueString();
        }
        catch (DebugException debugException) {
            return "";
        }
    }

    private String getExpressionText(IExpression expression) {
        String valueString;
        StringBuffer buff = new StringBuffer();
        IValue value = expression.getValue();
        buff.append(String.valueOf('\"') + expression.getExpressionText() + '\"');
        if (value != null && (valueString = this.getValueText(value)) != null && valueString.length() > 0) {
            buff.append("= ");
            buff.append(valueString);
        }
        return buff.toString();
    }

    private String getWatchExpressionText(IWatchExpression expression) {
        if (expression.hasErrors()) {
            String[] errors = expression.getErrorMessages();
            String error = errors != null && errors.length > 0 ? errors[0] : Messages.SPModelPresentation_evaluateFailMessage;
            return NLS.bind((String)Messages.SPModelPresentation_ERROR2, (Object[])new Object[]{expression.getExpressionText(), error});
        }
        return this.getExpressionText((IExpression)expression);
    }

    private String getBreakpointText(IBreakpoint breakpoint) {
        if (breakpoint instanceof SPLineBreakpoint) {
            SPLineBreakpoint spb = (SPLineBreakpoint)breakpoint;
            try {
                return String.valueOf(spb.getProcIdentifier().getProfileName()) + ": " + spb.getProcIdentifier().getDisplayString() + " " + NLS.bind((String)Messages.SPModelPresentation_line, (Object[])new Object[]{"" + spb.getLineNumber()});
            }
            catch (Exception ex) {
                DebuggerCorePlugin.getDefault().log(Messages.SPModelPresentation_breakpointTextFail, (Throwable)ex);
                return Messages.SPModelPresentation_breakpoint;
            }
        }
        return Messages.SPModelPresentation_breakpointUnknown;
    }

    private IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    private String getStackFrameText(IStackFrame frame) {
        SPStackFrame spframe = (SPStackFrame)frame;
        StringBuffer buffer = new StringBuffer(spframe.getProcIdentifier().getProcName());
        String paramstr = spframe.getParamStr();
        if (paramstr != null && paramstr.length() > 0) {
            buffer.append("(").append(paramstr).append(")");
        }
        try {
            buffer.append(": " + spframe.getLineNumber());
        }
        catch (DebugException debugException) {}
        return buffer.toString();
    }

    private String getVariableText(IVariable variable) {
        try {
            IValue v = variable.getValue();
            return String.valueOf(variable.getName()) + "= " + (v == null ? "null" : v.getValueString());
        }
        catch (DebugException ex) {
            DebuggerCorePlugin.getDefault().log(Messages.DebugException_occurred, (Throwable)ex);
            return Messages.SPModelPresentation_getVariableInfoFail;
        }
    }

    private String getThreadText(IThread thread) {
        try {
            return thread.getName();
        }
        catch (DebugException debugException) {
            return Messages.SPModelPresentation_thread;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof SPVariable) {
            if (((SPVariable)element).isGlobal()) {
                return DebuggerImages.getImage("globalvariable");
            }
            return DebuggerImages.getImage("localvariable");
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

