/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.api.script;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class BeforeDrawSeriesTitle
extends ChartTestCase {
    private static String OUTPUT = "BeforeDrawSeriesTitle.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new BeforeDrawSeriesTitle();
    }

    public BeforeDrawSeriesTitle() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = BeforeDrawSeriesTitle.createPieChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public static final Chart createPieChart() {
        ChartWithoutAxes cwoaPie = ChartWithoutAxesImpl.create();
        cwoaPie.setType("Pie Chart");
        cwoaPie.setScript("function beforeDrawSeriesTitle(series, label, scriptContext){label.setVisible(true);label.getCaption().setValue(\"Cities\"); label.getCaption().getColor().set(222, 32, 182);label.getCaption().getFont().setItalic(true);label.getCaption().getFont().setRotation(30);label.getCaption().getFont().setStrikethrough(true);label.getCaption().getFont().setSize(14);label.getCaption().getFont().setName(\"Arial\");label.getOutline().setVisible(true);label.getOutline().setThickness(3);series.getLabel().getCaption().getColor().set(12, 232, 182); series.getLabel().getCaption().getFont().setItalic(true);series.getLabel().getCaption().getFont().setRotation(30);series.getLabel().getCaption().getFont().setStrikethrough(true);series.getLabel().getCaption().getFont().setSize(14);series.getLabel().getCaption().getFont().setName(\"Arial\");series.getLabel().getOutline().setVisible(true);series.getLabel().getOutline().setThickness(3); }");
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)dsStringValue);
        SeriesDefinition series = SeriesDefinitionImpl.create();
        series.getSeries().add((Object)seCategory);
        cwoaPie.getSeriesDefinitions().add((Object)series);
        PieSeries ps = (PieSeries)PieSeriesImpl.create();
        ps.setDataSet((DataSet)dsNumericValues1);
        SeriesDefinition seGroup1 = SeriesDefinitionImpl.create();
        series.getSeriesPalette().update(-2);
        series.getSeriesDefinitions().add((Object)seGroup1);
        seGroup1.getSeries().add((Object)ps);
        return cwoaPie;
    }
}

