/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class GroupHandleTest
extends BaseTestCase {
    public void testIntervalRange() throws Exception {
        ULocale locale = ULocale.GERMANY;
        this.createDesign(locale);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        TableGroupHandle groupHandle = this.designHandle.getElementFactory().newTableGroup();
        groupHandle.setName("group");
        groupHandle.setKeyExpr("row[\"hello\"]");
        groupHandle.setIntervalRange("1,234.5");
        tableHandle.getGroups().add((DesignElementHandle)groupHandle);
        TableGroupHandle groupHandle2 = this.designHandle.getElementFactory().newTableGroup();
        groupHandle2.setName("group2");
        groupHandle2.setKeyExpr("row[\"hello2\"]");
        groupHandle2.setIntervalRange(1000.5);
        tableHandle.getGroups().add((DesignElementHandle)groupHandle2);
        GroupHandleTest.assertEquals((String)"1.234", (String)groupHandle.getStringProperty("intervalRange"));
        GroupHandleTest.assertEquals((Object)new Double(1000.5), (Object)new Double(groupHandle2.getIntervalRange()));
    }

    public void testProperties() throws Exception {
        this.openDesign("GroupHandleTest.xml");
        ListHandle list = (ListHandle)this.designHandle.findElement("My List");
        GroupHandleTest.assertNotNull((Object)list);
        SlotHandle groupSlot = list.getGroups();
        GroupHandle group = (GroupHandle)groupSlot.get(0);
        group.setName("group1");
        GroupHandleTest.assertEquals((String)"group1", (String)group.getDisplayLabel(2));
        GroupHandleTest.assertEquals((String)"2004/12/12", (String)group.getGroupStart());
        group.setPageBreakAfter("always");
        GroupHandleTest.assertEquals((String)"always", (String)group.getPageBreakAfter());
        GroupHandleTest.assertEquals((String)"always", (String)((String)group.getFactoryPropertyHandle("pageBreakAfter").getValue()));
        group.setPageBreakBefore("always-excluding-first");
        GroupHandleTest.assertEquals((String)"always-excluding-first", (String)group.getPageBreakBefore());
        group.setRepeatHeader(false);
        GroupHandleTest.assertFalse((boolean)group.repeatHeader());
        group.setHideDetail(true);
        GroupHandleTest.assertTrue((boolean)group.hideDetail());
        try {
            group.setPageBreakAfter("inherit");
            GroupHandleTest.fail();
        }
        catch (PropertyValueException e) {
            GroupHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        GroupHandleTest.assertNull((Object)group.getPropertyDefn("backgroundAttachment"));
        group.setName("  ");
        GroupHandleTest.assertEquals(null, (String)group.getDisplayLabel(0));
        group.setName("");
        GroupHandleTest.assertEquals(null, (String)group.getDisplayLabel(0));
        group.setInterval("prefix");
        GroupHandleTest.assertEquals((String)"prefix", (String)group.getInterval());
        group.setIntervalRange(0.1234);
        GroupHandleTest.assertTrue((0.1234 == group.getIntervalRange() ? 1 : 0) != 0);
        group.setKeyExpr("new key expression");
        GroupHandleTest.assertEquals((String)"new key expression", (String)group.getKeyExpr());
        group.setTocExpression("new toc expression");
        GroupHandleTest.assertEquals((String)"new toc expression", (String)group.getTocExpression());
        group.setTocExpression(null);
        GroupHandleTest.assertEquals((String)"new key expression", (String)group.getKeyExpr());
        GroupHandleTest.assertNull((Object)group.getTocExpression());
        group.setSortDirection("desc");
        GroupHandleTest.assertEquals((String)"desc", (String)group.getSortDirection());
        group.setOnPrepare("new prepare on the group");
        GroupHandleTest.assertEquals((String)"new prepare on the group", (String)group.getOnPrepare());
        GroupHandleTest.assertNull((Object)group.getBookmark());
        group.setBookmark("bookmark");
        GroupHandleTest.assertEquals((String)"bookmark", (String)group.getBookmark());
    }

    public void testHasHeaderAndFooter() throws DesignFileException, SemanticException {
        this.openDesign("GroupHandleTest.xml");
        ListHandle list = (ListHandle)this.designHandle.findElement("My List");
        SlotHandle groupSlot = list.getGroups();
        GroupHandle group = (GroupHandle)groupSlot.get(0);
        GroupHandleTest.assertEquals((boolean)true, (boolean)group.hasHeader());
        group.clearContents(0);
        GroupHandleTest.assertEquals((boolean)false, (boolean)group.hasHeader());
        GroupHandleTest.assertEquals((boolean)true, (boolean)group.hasFooter());
        group.clearContents(1);
        GroupHandleTest.assertEquals((boolean)false, (boolean)group.hasHeader());
    }

    public void testTOC() throws Exception {
        this.openDesign("GroupHandleTest.xml");
        ListHandle list = (ListHandle)this.designHandle.findElement("My List");
        SlotHandle groupSlot = list.getGroups();
        GroupHandle group = (GroupHandle)groupSlot.get(0);
        TOCHandle tocHandle = group.getTOC();
        SharedStyleHandle styleHandle = this.designHandle.findNativeStyle(tocHandle.getStyleName());
        styleHandle.dropAndClear();
        GroupHandleTest.assertNull((Object)tocHandle.getStyleName());
        TOC toc = StructureFactory.createTOC((String)"toc");
        tocHandle = group.addTOC(toc);
        GroupHandleTest.assertNotNull((Object)tocHandle);
        GroupHandleTest.assertEquals((String)"toc", (String)tocHandle.getExpression());
        GroupHandleTest.assertEquals((String)"toc", (String)group.getTocExpression());
        group.setTocExpression("toc2");
        GroupHandleTest.assertEquals((String)"toc2", (String)group.getTocExpression());
    }
}

