/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.project.facet;

import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.exception.BirtCoreException;
import org.eclipse.birt.integration.wtp.ui.internal.resource.BirtWTPMessages;
import org.eclipse.birt.integration.wtp.ui.internal.util.Logger;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.birt.integration.wtp.ui.project.facet.BirtFacetUtilFactory;
import org.eclipse.birt.integration.wtp.ui.project.facet.IBirtFacetConstants;
import org.eclipse.birt.integration.wtp.ui.project.facet.IBirtFacetUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class BirtFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate,
IBirtFacetConstants,
IBirtWizardConstants {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 4);
        try {
            IDataModel facetDataModel = (IDataModel)config;
            IDataModel masterDataModel = (IDataModel)facetDataModel.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
            IPath destPath = null;
            if (masterDataModel != null) {
                IFolder folder;
                String configFolder = BirtWizardUtil.getConfigFolder(masterDataModel);
                if (configFolder != null && (folder = BirtWizardUtil.getFolder(project, configFolder)) != null) {
                    destPath = folder.getFullPath();
                }
            } else {
                destPath = BirtWizardUtil.getWebContentPath(project);
            }
            if (destPath == null) {
                String message = BirtWTPMessages.BIRTErrors_wrong_webcontent;
                Logger.log(4, message);
                throw BirtCoreException.getException(message, null);
            }
            Map birtProperties = (Map)facetDataModel.getProperty("BirtFacetInstallDataModelProperties.BIRT_CONFIG");
            monitor.worked(1);
            this.preConfiguration(project, birtProperties, destPath.toFile().getName(), monitor);
            monitor.worked(1);
            this.processConfiguration(project, birtProperties, monitor);
            monitor.worked(1);
            BirtWizardUtil.doImports(project, null, destPath, monitor, new SimpleImportOverwriteQuery());
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    protected void preConfiguration(IProject project, Map birtProperties, String configFolder, IProgressMonitor monitor) throws CoreException {
        BirtWizardUtil.processCheckFolder(birtProperties, project, configFolder, monitor);
    }

    protected void processConfiguration(final IProject project, final Map birtProperties, final IProgressMonitor monitor) throws CoreException {
        final SimpleImportOverwriteQuery query = new SimpleImportOverwriteQuery();
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (BirtFacetUtilFactory.isWebApp25(modelProvider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        final IBirtFacetUtil util = BirtFacetUtilFactory.getInstance(modelProvider.getModelObject());
        modelProvider.modify(new Runnable(){

            @Override
            public void run() {
                util.configureWebApp((WebAppBean)birtProperties.get("webapp"), project, query, monitor);
                util.configureContextParam((Map)birtProperties.get("context-param"), project, query, monitor);
                util.configureListener((Map)birtProperties.get("listener"), project, query, monitor);
                util.configureServlet((Map)birtProperties.get("servlet"), project, query, monitor);
                util.configureServletMapping((Map)birtProperties.get("servlet-mapping"), project, query, monitor);
                util.configureFilter((Map)birtProperties.get("filter"), project, query, monitor);
                util.configureFilterMapping((Map)birtProperties.get("filter-mapping"), project, query, monitor);
                util.configureTaglib((Map)birtProperties.get("taglib"), project, query, monitor);
            }
        }, modelPath);
    }
}

