/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetPopulatorFactory;
import org.eclipse.birt.data.engine.impl.jointdataset.JointResultMetadata;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import testutil.ConfigText;

public class JointDataSetTest
extends APITestCase {
    private static int CARTESIAN_POPULATOR = 0;
    private static int BINARY_TREE_POPULATOR = 1;
    private static boolean ADD_FETCH_LIMIT = false;
    private ScriptContext cx;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestJointDataSet.TableName"), ConfigText.getString("Impl.TestJointDataSet.TableSQL"), ConfigText.getString("Impl.TestJointDataSet.TestDataFileName"));
    }

    @Before
    public void jointDataSetSetUp() throws Exception {
        this.cx = new ScriptContext();
    }

    @After
    public void jointDataSetTearDown() throws Exception {
        this.cx.close();
    }

    @Test
    public void testInnerJoin_DEFAULT() throws Exception {
        String s = this.basicJoinTest(0, CARTESIAN_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testLeftOuterJoin_DEFAULT() throws Exception {
        String s = this.basicJoinTest(1, CARTESIAN_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testRightOuterJoin_DEFAULT() throws Exception {
        String s = this.basicJoinTest(2, CARTESIAN_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testFullOuterJoin_DEFAULT() throws Exception {
        String s = this.basicJoinTest(3, CARTESIAN_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testInnerJoin_BINARY() throws Exception {
        String s = this.basicJoinTest(0, BINARY_TREE_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testLeftOuterJoin_BINARY() throws Exception {
        String s = this.basicJoinTest(1, BINARY_TREE_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testRightOuterJoin_BINARY() throws Exception {
        String s = this.basicJoinTest(2, BINARY_TREE_POPULATOR);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testComplexInnerJoin() throws Exception {
        String s = this.complexJoinTest(0);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testComplexLeftOuterJoin() throws Exception {
        String s = this.complexJoinTest(1);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testComplexRightOuterJoin() throws Exception {
        String s = this.complexJoinTest(2);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testComplexFullOuterJoin() throws Exception {
        String s = this.complexJoinTest(3);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testRowFetchLimit() throws Exception {
        ADD_FETCH_LIMIT = true;
        this.testPrint(this.basicJoinTest(0, BINARY_TREE_POPULATOR));
        ADD_FETCH_LIMIT = false;
        this.checkOutputFile();
    }

    private String complexJoinTest(int joinType) throws Exception {
        OdaDataSetDesign dset1 = this.newDataSet("dset1", "Select ID, CITY, STORE FROM " + this.getTestTableName() + " where ID > 4 and ID <> 7 and ID <> 9 order by ID asc");
        OdaDataSetDesign dset2 = this.newDataSet("dset2", "Select ID, SKU, CATEGORY, PRICE FROM " + this.getTestTableName() + " where ID < 20 and ID <> 10 and ID <> 13 order by ID asc");
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.ID"), (IScriptExpression)new ScriptExpression("dataSetRow.ID"), 1));
        JointDataSetDesign dset3 = new JointDataSetDesign("dset3", dset1.getName(), dset2.getName(), joinType, a);
        dset3.addComputedColumn((IComputedColumn)new ComputedColumn("group1.sum", "Total.sum(row[\"dset2::PRICE\"],null,0)"));
        dset3.addComputedColumn((IComputedColumn)new ComputedColumn("group2.sum", "Total.sum(row[\"dset2::PRICE\"],null,0)"));
        dset3.addComputedColumn((IComputedColumn)new ComputedColumn("cp3", "row[\"dset2::PRICE\"]+100"));
        dset3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"dset1::ID\"]!=15")));
        dset3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"dset1::ID\"]!=16")));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset3);
        ArrayList<JoinCondition> b = new ArrayList<JoinCondition>();
        b.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow[\"dset1::ID\"]"), (IScriptExpression)new ScriptExpression("dataSetRow[\"ID\"]"), 1));
        JointDataSetDesign dset4 = new JointDataSetDesign("dset4", dset3.getName(), dset1.getName(), joinType, b);
        dset4.addComputedColumn((IComputedColumn)new ComputedColumn("CC", "\"I am grand Dset\""));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset4);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset4);
        GroupDefinition group1 = new GroupDefinition();
        group1.setInterval(99);
        group1.setIntervalRange(10.0);
        group1.setIntervalStart((Object)new Integer(5));
        group1.setKeyExpression("row.G1");
        String G1 = "G1";
        ScriptExpression be1 = new ScriptExpression("dataSetRow[\"dset1::ID\"]");
        GroupDefinition group2 = new GroupDefinition();
        group2.setKeyExpression("row.G2");
        String G2 = "G2";
        ScriptExpression be2 = new ScriptExpression("dataSetRow[\"dset1::CITY\"]");
        query.addGroup((IGroupDefinition)group1);
        query.addGroup((IGroupDefinition)group2);
        query.addResultSetExpression(G1, (IBaseExpression)be1);
        query.addResultSetExpression(G2, (IBaseExpression)be2);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = preparedQuery.execute(null);
        IResultIterator ri = ((ResultIterator)qr.getResultIterator()).getOdiResult();
        Object s = "";
        int i = 0;
        while (i < ri.getResultClass().getFieldCount()) {
            s = (String)s + ri.getResultClass().getFieldName(i + 1) + "\t\t\t";
            ++i;
        }
        s = (String)s + "\n";
        long start = System.currentTimeMillis();
        int count = 0;
        do {
            IResultObject ro = ri.getCurrentResult();
            if (++count == 49) {
                System.out.print("ar");
            }
            int i2 = 0;
            while (i2 < ri.getResultClass().getFieldCount()) {
                s = (String)s + String.valueOf(ro.getFieldValue(i2 + 1)) + "\t\t\t";
                ++i2;
            }
            s = (String)s + "\n";
        } while (ri.next());
        System.out.println(count + ":" + (System.currentTimeMillis() - start));
        return s;
    }

    @Test
    public void testSelfInnerJoin() throws Exception {
        String s = this.selfJoinTest(0);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testSelfLeftOuterJoin() throws Exception {
        String s = this.selfJoinTest(1);
        this.testPrint(s);
        this.checkOutputFile();
    }

    @Test
    public void testSelfRightOuterJoin() throws Exception {
        String s = this.selfJoinTest(2);
        this.testPrint(s);
        this.checkOutputFile();
    }

    private String selfJoinTest(int joinType) throws Exception {
        OdaDataSetDesign dset = this.newDataSet("dset", "Select ID, CITY, STORE FROM " + this.getTestTableName() + " order by ID asc");
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.ID"), (IScriptExpression)new ScriptExpression("dataSetRow.ID"), 1));
        JointDataSetDesign dset2 = new JointDataSetDesign("dset2", dset.getName(), dset.getName(), joinType, a);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset2);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset2);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = preparedQuery.execute(null);
        IResultIterator ri = ((ResultIterator)qr.getResultIterator()).getOdiResult();
        Object s = "";
        int i = 0;
        while (i < ri.getResultClass().getFieldCount()) {
            s = (String)s + ri.getResultClass().getFieldName(i + 1) + "\t\t\t";
            ++i;
        }
        s = (String)s + "\n";
        long start = System.currentTimeMillis();
        int count = 0;
        do {
            IResultObject ro = ri.getCurrentResult();
            if (++count == 49) {
                System.out.print("ar");
            }
            int i2 = 0;
            while (i2 < ri.getResultClass().getFieldCount()) {
                s = (String)s + String.valueOf(ro.getFieldValue(i2 + 1)) + "\t\t\t";
                ++i2;
            }
            s = (String)s + "\n";
        } while (ri.next());
        System.out.println(count + ":" + (System.currentTimeMillis() - start));
        return s;
    }

    private String basicJoinTest(int joinType, int populateType) throws Exception, BirtException, DataException {
        IResultObject ro;
        OdaDataSetDesign dset1 = this.newDataSet("dset1", "Select ID, CITY, STORE FROM " + this.getTestTableName() + " where ID > 4 and ID <> 7 and ID <> 9 order by ID asc");
        if (ADD_FETCH_LIMIT) {
            dset1.setRowFetchLimit(6);
        }
        OdaDataSetDesign dset2 = this.newDataSet("dset2", "Select ID, SKU, CATEGORY, PRICE FROM " + this.getTestTableName() + " where ID < 20 and ID <> 10 and ID <> 13 order by ID asc");
        if (ADD_FETCH_LIMIT) {
            dset2.setRowFetchLimit(6);
        }
        QueryDefinition query1 = this.newReportQuery((IBaseDataSetDesign)dset1);
        QueryResults qr1 = (QueryResults)this.dataEngine.prepare((IQueryDefinition)query1).execute(null);
        QueryDefinition query2 = this.newReportQuery((IBaseDataSetDesign)dset2);
        QueryResults qr2 = (QueryResults)this.dataEngine.prepare((IQueryDefinition)query2).execute(null);
        IResultIterator it1 = ((ResultIterator)qr1.getResultIterator()).getOdiResult();
        IResultIterator it2 = ((ResultIterator)qr2.getResultIterator()).getOdiResult();
        int[] isFromLeft = new int[]{1, 1, 1, 2, 2, 2, 2};
        int[] index = new int[]{1, 2, 3, 1, 2, 3, 4};
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        projectedColumns.add(new ResultFieldMetadata(1, "dset1::" + it1.getResultClass().getFieldName(1), it1.getResultClass().getFieldName(1), it1.getResultClass().getFieldValueClass(1), it1.getResultClass().getFieldNativeTypeName(1), false));
        projectedColumns.add(new ResultFieldMetadata(3, "dset1::" + it1.getResultClass().getFieldName(2), it1.getResultClass().getFieldName(2), it1.getResultClass().getFieldValueClass(2), it1.getResultClass().getFieldNativeTypeName(2), false));
        projectedColumns.add(new ResultFieldMetadata(4, "dset1::" + it1.getResultClass().getFieldName(3), it1.getResultClass().getFieldName(3), it1.getResultClass().getFieldValueClass(3), it1.getResultClass().getFieldNativeTypeName(3), false));
        projectedColumns.add(new ResultFieldMetadata(2, "dset2::" + it2.getResultClass().getFieldName(1), it2.getResultClass().getFieldName(1), it2.getResultClass().getFieldValueClass(1), it2.getResultClass().getFieldNativeTypeName(1), false));
        projectedColumns.add(new ResultFieldMetadata(5, "dset2::" + it2.getResultClass().getFieldName(2), it2.getResultClass().getFieldName(2), it2.getResultClass().getFieldValueClass(2), it2.getResultClass().getFieldNativeTypeName(2), false));
        projectedColumns.add(new ResultFieldMetadata(6, "dset2::" + it2.getResultClass().getFieldName(3), it2.getResultClass().getFieldName(3), it2.getResultClass().getFieldValueClass(3), it2.getResultClass().getFieldNativeTypeName(3), false));
        projectedColumns.add(new ResultFieldMetadata(7, "dset2::" + it2.getResultClass().getFieldName(4), it2.getResultClass().getFieldName(4), it2.getResultClass().getFieldValueClass(4), it2.getResultClass().getFieldNativeTypeName(4), false));
        ResultClass resultClass = new ResultClass(projectedColumns);
        JointResultMetadata meta = new JointResultMetadata((IResultClass)resultClass, isFromLeft, index);
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.ID"), (IScriptExpression)new ScriptExpression("dataSetRow.ID"), 1));
        JoinConditionMatcher matcher = new JoinConditionMatcher(((ResultIterator)qr1.getResultIterator()).getOdiResult(), ((ResultIterator)qr2.getResultIterator()).getOdiResult(), qr1.getQueryScope(), qr2.getQueryScope(), this.cx, a);
        IDataSetPopulator populator = null;
        int fetchRowLimit = 0;
        if (ADD_FETCH_LIMIT) {
            fetchRowLimit = 4;
        }
        populator = populateType == BINARY_TREE_POPULATOR ? JointDataSetPopulatorFactory.getBinaryTreeDataSetPopulator((IResultIterator)it1, (IResultIterator)it2, (JointResultMetadata)meta, (IJoinConditionMatcher)matcher, (int)joinType, (DataEngineSession)((DataEngineImpl)this.dataEngine).getSession(), (int)fetchRowLimit) : JointDataSetPopulatorFactory.getCartesianJointDataSetPopulator((IResultIterator)it1, (IResultIterator)it2, (JointResultMetadata)meta, (IJoinConditionMatcher)matcher, (int)joinType, (DataEngineSession)((DataEngineImpl)this.dataEngine).getSession(), (int)fetchRowLimit);
        Object s = "";
        int i = 0;
        while (i < resultClass.getFieldCount()) {
            s = (String)s + resultClass.getFieldName(i + 1) + "\t\t\t";
            ++i;
        }
        s = (String)s + "\n";
        long start = System.currentTimeMillis();
        int count = 0;
        while ((ro = populator.next()) != null) {
            if (++count == 49) {
                System.out.print("ar");
            }
            int i2 = 0;
            while (i2 < resultClass.getFieldCount()) {
                s = (String)s + String.valueOf(ro.getFieldValue(i2 + 1)) + "\t\t\t";
                ++i2;
            }
            s = (String)s + "\n";
        }
        System.out.println(count + ":" + (System.currentTimeMillis() - start));
        return s;
    }

    @Test
    public void testAlias() throws Exception {
        String fieldName = "dset2::CITY";
        OdaDataSetDesign dset = this.newDataSet("dset", "Select ID, CITY, STORE FROM " + this.getTestTableName() + " order by ID asc");
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.ID"), (IScriptExpression)new ScriptExpression("dataSetRow.ID"), 1));
        JointDataSetDesign dset2 = new JointDataSetDesign("dset2", dset.getName(), dset.getName(), 0, a);
        ColumnDefinition columnDefinition = new ColumnDefinition(fieldName);
        columnDefinition.setAlias("Alias");
        dset2.addResultSetHint((IColumnDefinition)columnDefinition);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset2);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset2);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = preparedQuery.execute(null);
        IResultClass resultClass = ((ResultIterator)qr.getResultIterator()).getOdiResult().getResultClass();
        Assert.assertEquals((Object)resultClass.getFieldAlias(resultClass.getFieldIndex(fieldName)), (Object)columnDefinition.getAlias());
    }
}

