/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.junit.Ignore;
import org.junit.Test;
import testutil.BaseTestCase;

@Ignore(value="Test must be run manually")
public class DiskBasedManualTest
extends BaseTestCase {
    private String url = "jdbc:mysql://spmdb/test";
    private String driverClass = "com.mysql.jdbc.Driver";
    private String user = "root";
    private String password = "root";
    private String queryText = "select * from l_customer";
    private OdaDataSourceDesign odaDataSource;
    private OdaDataSetDesign odaDataSet;
    private QueryDefinition queryDefinition;
    private String[] columnNameArray;
    private IBaseExpression[] expressionArray;
    private static final String JDBC_DATA_SOURCE_TYPE = "org.eclipse.birt.report.data.oda.jdbc";
    private static final String JDBC_DATA_SET_TYPE = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";

    private IBaseDataSourceDesign getDataSource() throws Exception {
        if (this.odaDataSource != null) {
            return this.odaDataSource;
        }
        this.odaDataSource = new OdaDataSourceDesign("Test Data Source");
        this.odaDataSource.setExtensionID(JDBC_DATA_SOURCE_TYPE);
        this.odaDataSource.addPublicProperty("odaURL", this.url);
        this.odaDataSource.addPublicProperty("odaDriverClass", this.driverClass);
        this.odaDataSource.addPublicProperty("odaUser", this.user);
        this.odaDataSource.addPublicProperty("odaPassword", this.password);
        return this.odaDataSource;
    }

    private IBaseDataSetDesign getDataSet() throws Exception {
        if (this.odaDataSet != null) {
            return this.odaDataSet;
        }
        this.odaDataSet = new OdaDataSetDesign("Test Data Set");
        this.odaDataSet.setDataSource(this.getDataSource().getName());
        this.odaDataSet.setExtensionID(JDBC_DATA_SET_TYPE);
        this.odaDataSet.setQueryText(this.getQueryText());
        ComputedColumn cc = new ComputedColumn("C_CC1", "row.C_CUSTKEY+10", 2);
        this.odaDataSet.addComputedColumn((IComputedColumn)cc);
        return this.odaDataSet;
    }

    private QueryDefinition getQueryDefn() throws Exception {
        if (this.queryDefinition != null) {
            return this.queryDefinition;
        }
        this.queryDefinition = new QueryDefinition();
        this.queryDefinition.setDataSetName(this.getDataSet().getName());
        this.expressionArray = new IBaseExpression[1];
        this.columnNameArray = new String[1];
        ScriptExpression expr = new ScriptExpression("dataSetRow.C_CC1");
        this.expressionArray[0] = expr;
        this.columnNameArray[0] = "C_CC1";
        int i = 0;
        while (i < this.expressionArray.length) {
            this.queryDefinition.addResultSetExpression(this.columnNameArray[i], this.expressionArray[i]);
            ++i;
        }
        SortDefinition sd = new SortDefinition();
        sd.setColumn("C_CC1");
        sd.setSortDirection(1);
        this.queryDefinition.addSort(sd);
        return this.queryDefinition;
    }

    private String getQueryText() {
        int maxRows = 20000;
        if (maxRows > 0) {
            return this.queryText + " where l_customer.C_CUSTKEY < " + maxRows;
        }
        return this.queryText;
    }

    @Test
    public void testDiskBased() throws BirtException, Exception {
        System.setProperty("BIRT_HOME", "./test");
        System.setProperty("PROPERTY_RUN_UNDER_ECLIPSE", "false");
        Platform.startup(null);
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DiskBasedManualTest.getTempDir());
        DataEngine de = DataEngine.newDataEngine((DataEngineContext)context);
        de.defineDataSource(this.getDataSource());
        de.defineDataSet(this.getDataSet());
        IPreparedQuery pq = de.prepare((IQueryDefinition)this.getQueryDefn());
        IQueryResults qr = pq.execute(null);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < this.columnNameArray.length) {
                System.out.println(ri.getValue(this.columnNameArray[i]));
                ++i;
            }
        }
        ri.close();
        qr.close();
        de.shutdown();
    }
}

