/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.shared.common.error.StandardException;

public class SequenceGenerator {
    private static final int PREALLOCATION_THRESHHOLD = 1;
    public static final int RET_I_AM_CONFUSED = 0;
    public static final int RET_OK = 1;
    public static final int RET_MARK_EXHAUSTED = 2;
    public static final int RET_ALLOCATE_NEW_VALUES = 3;
    public static final int CVAA_STATUS = 0;
    public static final int CVAA_CURRENT_VALUE = 1;
    public static final int CVAA_LAST_ALLOCATED_VALUE = 2;
    public static final int CVAA_NUMBER_OF_VALUES_ALLOCATED = 3;
    public static final int CVAA_LENGTH = 4;
    private final boolean _CAN_CYCLE;
    private final boolean _STEP_INCREASES;
    private final long _INCREMENT;
    private final long _MAX_VALUE;
    private final long _MIN_VALUE;
    private final long _RESTART_VALUE;
    private final String _SCHEMA_NAME;
    private final String _SEQUENCE_NAME;
    private final SequencePreallocator _PREALLOCATOR;
    private boolean _isExhausted;
    private long _currentValue;
    private long _remainingPreallocatedValues;

    public SequenceGenerator(Long currentValue, boolean canCycle, long increment, long maxValue, long minValue, long restartValue, String schemaName, String sequenceName, SequencePreallocator sequencePreallocator) {
        if (currentValue == null) {
            this._isExhausted = true;
            this._currentValue = 0L;
        } else {
            this._isExhausted = false;
            this._currentValue = currentValue;
        }
        this._CAN_CYCLE = canCycle;
        this._INCREMENT = increment;
        this._MAX_VALUE = maxValue;
        this._MIN_VALUE = minValue;
        this._RESTART_VALUE = restartValue;
        this._STEP_INCREASES = this._INCREMENT > 0L;
        this._SCHEMA_NAME = schemaName;
        this._SEQUENCE_NAME = sequenceName;
        this._PREALLOCATOR = sequencePreallocator;
        this._remainingPreallocatedValues = 1L;
    }

    public synchronized SequenceGenerator clone(boolean restart) {
        Object startValue = restart ? Long.valueOf(this._RESTART_VALUE) : (this._isExhausted ? null : Long.valueOf(this._currentValue));
        return new SequenceGenerator((Long)startValue, this._CAN_CYCLE, this._INCREMENT, this._MAX_VALUE, this._MIN_VALUE, this._RESTART_VALUE, this._SCHEMA_NAME, this._SEQUENCE_NAME, this._PREALLOCATOR);
    }

    public synchronized SequenceGenerator clone(Long newStartValue) {
        return new SequenceGenerator(newStartValue, this._CAN_CYCLE, this._INCREMENT, this._MAX_VALUE, this._MIN_VALUE, this._RESTART_VALUE, this._SCHEMA_NAME, this._SEQUENCE_NAME, this._PREALLOCATOR);
    }

    public synchronized String getSchemaName() {
        return this._SCHEMA_NAME;
    }

    public synchronized String getName() {
        return this._SEQUENCE_NAME;
    }

    public synchronized void allocateNewRange(long expectedCurrentValue, long numberOfAllocatedValues) {
        if (this._currentValue == expectedCurrentValue) {
            this._remainingPreallocatedValues = numberOfAllocatedValues;
        }
    }

    public synchronized Long peekAtCurrentValue() {
        Long currentValue = null;
        if (!this._isExhausted) {
            currentValue = this._currentValue;
        }
        return currentValue;
    }

    public synchronized long[] getCurrentValueAndAdvance() throws StandardException {
        if (this._isExhausted) {
            throw StandardException.newException("2200H.S", this._SCHEMA_NAME, this._SEQUENCE_NAME);
        }
        long[] retval = new long[4];
        retval[0] = 0L;
        retval[1] = this._currentValue;
        this.advanceValue(retval);
        return retval;
    }

    private void advanceValue(long[] retval) throws StandardException {
        long nextValue = this._currentValue + this._INCREMENT;
        if (this.overflowed(this._currentValue, nextValue)) {
            if (!this._CAN_CYCLE) {
                this.markExhausted(retval);
                return;
            }
            nextValue = this._INCREMENT > 0L ? this._MIN_VALUE : this._MAX_VALUE;
        }
        --this._remainingPreallocatedValues;
        if (this._remainingPreallocatedValues < 1L) {
            this.computeNewAllocation(this._currentValue, retval);
            return;
        }
        this._currentValue = nextValue;
        retval[0] = 1L;
    }

    private void markExhausted(long[] retval) {
        this._isExhausted = true;
        retval[0] = 2L;
    }

    private boolean overflowed(long originalValue, long incrementedValue) {
        boolean overflowed;
        boolean bl = overflowed = this._STEP_INCREASES == incrementedValue < originalValue;
        if (!overflowed) {
            overflowed = this._STEP_INCREASES ? incrementedValue > this._MAX_VALUE : incrementedValue < this._MIN_VALUE;
        }
        return overflowed;
    }

    private void computeNewAllocation(long oldCurrentValue, long[] retval) throws StandardException {
        long valuesToAllocate;
        long newValueOnDisk;
        int preferredValuesPerAllocation = this.computePreAllocationCount();
        long remainingLegalValues = this.computeRemainingValues(oldCurrentValue);
        if (remainingLegalValues >= (long)preferredValuesPerAllocation) {
            newValueOnDisk = oldCurrentValue + (long)preferredValuesPerAllocation * this._INCREMENT;
            valuesToAllocate = preferredValuesPerAllocation;
        } else if (this._CAN_CYCLE) {
            long spillOverValues = (long)preferredValuesPerAllocation - remainingLegalValues;
            newValueOnDisk = this._RESTART_VALUE + --spillOverValues * this._INCREMENT;
            valuesToAllocate = preferredValuesPerAllocation;
        } else {
            if (remainingLegalValues <= 0L) {
                this.markExhausted(retval);
                return;
            }
            valuesToAllocate = remainingLegalValues;
            newValueOnDisk = oldCurrentValue + valuesToAllocate * this._INCREMENT;
        }
        retval[3] = valuesToAllocate + 1L;
        retval[2] = newValueOnDisk;
        retval[0] = 3L;
    }

    private long computeRemainingValues(long oldCurrentValue) {
        long spaceLeft;
        long l = spaceLeft = this._STEP_INCREASES ? this._MAX_VALUE - oldCurrentValue : -(this._MIN_VALUE - oldCurrentValue);
        if (spaceLeft < 0L) {
            spaceLeft = Long.MAX_VALUE;
        }
        long divisor = this._STEP_INCREASES ? this._INCREMENT : -this._INCREMENT;
        return spaceLeft / divisor;
    }

    private int computePreAllocationCount() {
        double chunkSize;
        int unhappyResult;
        int happyResult = this._PREALLOCATOR.nextRangeSize(this._SCHEMA_NAME, this._SEQUENCE_NAME);
        if (happyResult < (unhappyResult = 1)) {
            return unhappyResult;
        }
        double min = this._MIN_VALUE;
        double max = this._MAX_VALUE;
        double range = max - min;
        double step = this._INCREMENT;
        if (step < 0.0) {
            step = -step;
        }
        if ((chunkSize = step * (double)happyResult) > 9.223372036854776E18) {
            return unhappyResult;
        }
        if (chunkSize > range) {
            return unhappyResult;
        }
        return happyResult;
    }
}

