/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Font;
import org.openpdf.text.Rectangle;
import org.openpdf.text.pdf.BaseFont;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfCopy;
import org.openpdf.text.pdf.PdfGState;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.PdfStamper;
import org.openpdf.text.utils.PdfBatch;

public final class PdfBatchUtils {
    private PdfBatchUtils() {
    }

    public static Path merge(List<Path> inputs, Path output) throws IOException, DocumentException {
        Objects.requireNonNull(inputs, "inputs");
        Objects.requireNonNull(output, "output");
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(output.toFile());){
            Document doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)fos);
            doc.open();
            for (Path in : inputs) {
                try (PdfReader reader = new PdfReader(Files.readAllBytes(in));){
                    int n = reader.getNumberOfPages();
                    for (int i = 1; i <= n; ++i) {
                        copy.addPage(copy.getImportedPage(reader, i));
                    }
                }
            }
            doc.close();
        }
        return output;
    }

    public static PdfBatch.BatchResult<Path> batchMerge(List<MergeJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(job -> () -> PdfBatchUtils.merge(job.inputs, job.output)).toList(), onSuccess, onFailure);
    }

    public static Path watermark(Path input, Path output, String text, float fontSize, float opacity) throws IOException, DocumentException {
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (PdfReader reader = new PdfReader(Files.readAllBytes(input));
             FileOutputStream out = new FileOutputStream(output.toFile());){
            PdfStamper stamper = new PdfStamper(reader, out);
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", true);
            Font font = new Font(bf, fontSize);
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(opacity);
            int n = reader.getNumberOfPages();
            for (int i = 1; i <= n; ++i) {
                Rectangle pageSize = reader.getPageSizeWithRotation(i);
                float x = (pageSize.getLeft() + pageSize.getRight()) / 2.0f;
                float y = (pageSize.getTop() + pageSize.getBottom()) / 2.0f;
                PdfContentByte over = stamper.getOverContent(i);
                over.saveState();
                over.setGState(gs);
                over.beginText();
                over.setFontAndSize(bf, font.getSize());
                over.showTextAligned(1, text, x, y, 45.0f);
                over.endText();
                over.restoreState();
            }
            stamper.close();
        }
        return output;
    }

    public static PdfBatch.BatchResult<Path> batchWatermark(List<WatermarkJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> PdfBatchUtils.watermark(j.input, j.output, j.text, j.fontSize, j.opacity)).toList(), onSuccess, onFailure);
    }

    public static Path encrypt(Path input, Path output, String userPassword, String ownerPassword, int permissions, int encryptionType) throws IOException, DocumentException {
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (PdfReader reader = new PdfReader(Files.readAllBytes(input));
             FileOutputStream out = new FileOutputStream(output.toFile());){
            PdfStamper stamper = new PdfStamper(reader, out);
            stamper.setEncryption(userPassword != null ? userPassword.getBytes() : null, ownerPassword != null ? ownerPassword.getBytes() : null, permissions, encryptionType);
            stamper.close();
        }
        return output;
    }

    public static PdfBatch.BatchResult<Path> batchEncrypt(List<EncryptJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> PdfBatchUtils.encrypt(j.input, j.output, j.userPassword, j.ownerPassword, j.permissions, j.encryptionType)).toList(), onSuccess, onFailure);
    }

    public static List<Path> split(Path input, Path outputDir, String baseName) throws IOException, DocumentException {
        Files.createDirectories(outputDir, new FileAttribute[0]);
        ArrayList<Path> outputs = new ArrayList<Path>();
        try (PdfReader reader = new PdfReader(Files.readAllBytes(input));){
            int n = reader.getNumberOfPages();
            for (int i = 1; i <= n; ++i) {
                Path out = outputDir.resolve(baseName + "_page" + i + ".pdf");
                try (FileOutputStream fos = new FileOutputStream(out.toFile());){
                    Document doc = new Document(reader.getPageSizeWithRotation(i));
                    PdfCopy copy = new PdfCopy(doc, (OutputStream)fos);
                    doc.open();
                    copy.addPage(copy.getImportedPage(reader, i));
                    doc.close();
                }
                outputs.add(out);
            }
        }
        return outputs;
    }

    public static PdfBatch.BatchResult<List<Path>> batchSplit(List<SplitJob> jobs, Consumer<List<Path>> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> PdfBatchUtils.split(j.input, j.outputDir, j.baseName)).toList(), onSuccess, onFailure);
    }

    public static int perms(boolean print, boolean modify, boolean copy, boolean annotate) {
        int p = 0;
        if (print) {
            p |= 0x804;
        }
        if (modify) {
            p |= 8;
        }
        if (copy) {
            p |= 0x10;
        }
        if (annotate) {
            p |= 0x20;
        }
        return p;
    }

    public static int aes128() {
        return 2;
    }

    public static int aes256() {
        return 4;
    }

    private static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public record SplitJob(Path input, Path outputDir, String baseName) {
    }

    public record EncryptJob(Path input, Path output, String userPassword, String ownerPassword, int permissions, int encryptionType) {
    }

    public record WatermarkJob(Path input, Path output, String text, float fontSize, float opacity) {
    }

    public record MergeJob(List<Path> inputs, Path output) {
    }
}

